/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.spi.ContentTypeAware;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

final class RestOpenApiHelper {
    private static final Pattern HOST_PATTERN = Pattern.compile("https?://[^:]+(:\\d+)?", 2);
    private static final List<String> YAML_CONTENT_TYPES = Arrays.asList("application/yaml", "application/yml", "text/yaml", "text/yml", "text/x-yaml");

    private RestOpenApiHelper() {
    }

    public static String isMediaRange(String given, String name) {
        return StringHelper.notEmpty((String)given, (String)name);
    }

    public static boolean isYamlResource(Resource resource) {
        Objects.requireNonNull(resource, "resource cannot be null");
        if (resource instanceof ContentTypeAware) {
            String contentType = ((ContentTypeAware)resource).getContentType();
            return RestOpenApiHelper.isYamlResourceLocation(resource.getLocation()) || RestOpenApiHelper.isYamlContentType(contentType);
        }
        return RestOpenApiHelper.isYamlResourceLocation(resource.getLocation());
    }

    static String isHostParam(String given) {
        String hostUri = StringHelper.notEmpty((String)given, (String)"host");
        Matcher matcher = HOST_PATTERN.matcher(given);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("host must be an absolute URI (e.g. http://api.example.com), given: `" + hostUri + "`");
        }
        return hostUri;
    }

    private static boolean isYamlContentType(String contentType) {
        if (ObjectHelper.isEmpty((String)contentType)) {
            return false;
        }
        return Stream.of(contentType.split(";")).map(String::trim).anyMatch(YAML_CONTENT_TYPES::contains);
    }

    private static boolean isYamlResourceLocation(String location) {
        if (ObjectHelper.isEmpty((String)location)) {
            return false;
        }
        return location.toLowerCase().endsWith(".yml") || location.toLowerCase().endsWith(".yaml");
    }
}

