/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.process;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.Map;
import org.apache.camel.maven.htmlxlsx.model.TestResult;

public class XmlToCamelRouteCoverageConverter {
    private final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private final XmlMapper xmlMapper = new XmlMapper();

    public TestResult convert(String source) {
        try {
            Map map = (Map)this.xmlMapper.readValue(source, Map.class);
            String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)map);
            return this.readValue(json);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected TestResult readValue(String json) throws JsonProcessingException {
        return (TestResult)this.objectMapper.readValue(json, TestResult.class);
    }
}

