/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.process;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    private static final String OUTPUT_FILE = "%s.html";

    public String getLastElementOfPath(String path) {
        return Paths.get(path, new String[0]).getFileName().toString();
    }

    public String readFile(String inputFile) throws IOException {
        Path inputFilePath = Paths.get(inputFile, new String[0]);
        return Files.readString(Paths.get(inputFilePath.toString(), new String[0]));
    }

    public String write(String rendered, String inputFileName, File outputPath) throws IOException {
        Path writeOutputPath = this.outputFile(inputFileName, outputPath.getPath());
        Files.writeString(writeOutputPath, (CharSequence)rendered, new OpenOption[0]);
        return writeOutputPath.toString();
    }

    public void write(String content, Path outputPath) throws IOException {
        outputPath.getParent().toFile().mkdirs();
        Files.writeString(outputPath, (CharSequence)content, new OpenOption[0]);
    }

    public Path outputFile(String inputFileName, String outputPath) {
        Path outputFileName = Paths.get(String.format(OUTPUT_FILE, this.removeFileExtension(inputFileName)), new String[0]);
        return Paths.get(outputPath, outputFileName.toString());
    }

    public String removeFileExtension(String filename) {
        if (filename == null || filename.isEmpty()) {
            return filename;
        }
        String extPattern = "(?<!^)[.][^.]*$";
        return filename.replaceAll(extPattern, "");
    }

    public Set<String> filesInDirectory(File dir) throws IOException {
        HashSet<String> fileList = new HashSet<String>();
        Path dirPath = Paths.get(dir.getPath(), new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath);){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                fileList.add(path.toString());
            }
        }
        return fileList;
    }

    public String readFileFromClassPath(String path) throws IOException {
        return IOUtils.resourceToString((String)FilenameUtils.separatorsToUnix((String)path), (Charset)Charset.defaultCharset(), (ClassLoader)FileUtil.class.getClassLoader());
    }
}

