/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.htmlxlsx.model.EipAttribute;

public class Components {
    private Map<String, List<EipAttribute>> attributeMap = new HashMap<String, List<EipAttribute>>();
    @JsonIgnore
    private final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);

    @JsonAnySetter
    public void setAttribute(String key, Object value) throws JsonProcessingException {
        List<EipAttribute> listValue;
        if (value instanceof String) {
            EipAttribute eipAttribute = (EipAttribute)this.objectMapper.readValue(String.format("{\"%s\":\"%s\"}", key, value), EipAttribute.class);
            listValue = Collections.singletonList(eipAttribute);
        } else if (!(value instanceof List)) {
            String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
            EipAttribute eipAttribute = (EipAttribute)this.objectMapper.readValue(json, EipAttribute.class);
            listValue = Collections.singletonList(eipAttribute);
        } else {
            String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
            listValue = (List<EipAttribute>)this.objectMapper.readValue(json, (TypeReference)new TypeReference<List<EipAttribute>>(){});
        }
        this.attributeMap.put(key, listValue);
    }

    public Map<String, List<EipAttribute>> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, List<EipAttribute>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public String toString() {
        return "Components{attributeMap=" + String.valueOf(this.attributeMap) + "}";
    }
}

