/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.loader.tools.DefaultLaunchScript;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.Repackager;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class RepackageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private File sourceJar;
    @Parameter(required=true)
    private String mainClass;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="true")
    private boolean backupSource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File sourceJarFile = this.getSourceJar();
            if (!sourceJarFile.exists()) {
                throw new MojoFailureException("Source JAR does not exist: " + String.valueOf(sourceJarFile));
            }
            this.getLog().info((CharSequence)("Repackaging " + String.valueOf(sourceJarFile) + " using Spring Boot loader tools"));
            Repackager repackager = new Repackager(sourceJarFile);
            repackager.setBackupSource(this.backupSource);
            repackager.setMainClass(this.mainClass);
            DefaultLaunchScript launchScript = new DefaultLaunchScript(null, null);
            File targetFile = this.getTargetFile();
            repackager.repackage(targetFile, this::getLibraries, (LaunchScript)launchScript);
            this.getLog().info((CharSequence)("Successfully created self-executing JAR: " + String.valueOf(targetFile)));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to repackage JAR", (Exception)e);
        }
    }

    private File getSourceJar() {
        if (this.sourceJar != null) {
            return this.sourceJar;
        }
        return new File(this.outputDirectory, this.finalName + ".jar");
    }

    private File getTargetFile() {
        return new File(this.outputDirectory, this.finalName + ".jar");
    }

    private void getLibraries(LibraryCallback callback) throws IOException {
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            File file;
            if (!this.includeArtifact(artifact) || (file = artifact.getFile()) == null || !file.exists()) continue;
            LibraryScope scope = this.getLibraryScope(artifact);
            this.getLog().debug((CharSequence)("Including dependency: " + String.valueOf(artifact) + " with scope: " + String.valueOf(scope)));
            callback.library(new Library(file, scope));
        }
    }

    private boolean includeArtifact(Artifact artifact) {
        String scope = artifact.getScope();
        return "compile".equals(scope) || "runtime".equals(scope) || "provided".equals(scope) && artifact.getGroupId().startsWith("org.apache.camel");
    }

    private LibraryScope getLibraryScope(Artifact artifact) {
        String scope;
        switch (scope = artifact.getScope()) {
            case "compile": {
                return LibraryScope.COMPILE;
            }
            case "runtime": {
                return LibraryScope.RUNTIME;
            }
            case "provided": {
                return LibraryScope.PROVIDED;
            }
        }
        return LibraryScope.COMPILE;
    }
}

