/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.util;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MonoPublisher<T>
implements Publisher<T> {
    private final T item;

    public MonoPublisher(T item) {
        this.item = item;
    }

    public void subscribe(final Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber must not be null");
        subscriber.onSubscribe(new Subscription(){
            private boolean terminated;

            public void request(long l) {
                if (this.terminated) {
                    return;
                }
                this.terminated = true;
                if (l <= 0L) {
                    subscriber.onError((Throwable)new IllegalArgumentException("3.9"));
                } else {
                    subscriber.onNext(MonoPublisher.this.item);
                    subscriber.onComplete();
                }
            }

            public void cancel() {
                this.terminated = true;
            }
        });
    }
}

