/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qdrant;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.qdrant.client.QdrantClient;
import io.qdrant.client.QdrantGrpcClient;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.qdrant.Qdrant;
import org.apache.camel.component.qdrant.QdrantConfiguration;
import org.apache.camel.component.qdrant.QdrantProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.5.0", scheme="qdrant", title="Qdrant", syntax="qdrant:collection", producerOnly=true, category={Category.DATABASE, Category.AI}, headersClass=Qdrant.Headers.class)
public class QdrantEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @Metadata(required=true)
    @UriPath(description="The collection Name")
    private final String collection;
    @UriParam
    private QdrantConfiguration configuration;
    private volatile boolean closeClient;
    private volatile QdrantClient client;

    public QdrantEndpoint(String endpointUri, Component component, String collection, QdrantConfiguration configuration) {
        super(endpointUri, component);
        this.collection = collection;
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.configuration.getHost() + ":" + this.configuration.getPort();
    }

    public String getServiceProtocol() {
        return "grpc";
    }

    public QdrantConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getCollection() {
        return this.collection;
    }

    public QdrantClient getClient() {
        if (this.client == null) {
            this.lock.lock();
            try {
                if (this.client == null) {
                    this.client = this.configuration.getClient();
                    this.closeClient = false;
                    if (this.client == null) {
                        this.client = this.createClient();
                        this.closeClient = true;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.client;
    }

    public Producer createProducer() throws Exception {
        return new QdrantProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.client != null && this.closeClient) {
            this.client.close();
            this.client = null;
            this.closeClient = false;
        }
    }

    private QdrantClient createClient() {
        QdrantGrpcClient.Builder builder = QdrantGrpcClient.newBuilder((ManagedChannel)this.createChannel(), (boolean)true);
        builder.withTimeout(this.configuration.getTimeout());
        if (this.configuration.getApiKey() != null) {
            builder.withApiKey(this.configuration.getApiKey());
        }
        return new QdrantClient(builder.build());
    }

    private ManagedChannel createChannel() {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)this.configuration.getHost(), (int)this.configuration.getPort());
        if (this.configuration.isTls()) {
            builder.useTransportSecurity();
        } else {
            builder.usePlaintext();
        }
        return builder.build();
    }
}

