/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qdrant.transform;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import io.qdrant.client.PointIdFactory;
import io.qdrant.client.ValueFactory;
import io.qdrant.client.VectorsFactory;
import io.qdrant.client.grpc.Points;
import java.util.UUID;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="qdrant:embeddings", description="Prepares the message to become an object writable by Qdrant component")
public class QdrantEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Embedding embedding = (Embedding)message.getHeader("CamelLangChain4jEmbeddingsVector", Embedding.class);
        TextSegment text = (TextSegment)message.getBody(TextSegment.class);
        Points.PointId id = (Points.PointId)message.getHeader("CamelQdrantPointId", () -> PointIdFactory.id((UUID)UUID.randomUUID()), Points.PointId.class);
        Points.PointStruct.Builder builder = Points.PointStruct.newBuilder();
        builder.setId(id);
        builder.setVectors(VectorsFactory.vectors((float[])embedding.vector()));
        if (text != null) {
            builder.putPayload("text_segment", ValueFactory.value((String)text.text()));
            Metadata metadata = text.metadata();
            metadata.toMap().forEach((key, value) -> builder.putPayload(key, ValueFactory.value((String)((String)value))));
        }
        message.setBody((Object)builder.build());
    }
}

