/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PulsarPath {
    private static final Pattern PATTERN = Pattern.compile("^(persistent|non-persistent):?/?/(.+)/(.+)/(.+)$");
    private String persistence;
    private String tenant;
    private String namespace;
    private String topic;
    private boolean autoConfigurable;

    public PulsarPath(String path) {
        Matcher matcher = PATTERN.matcher(path);
        this.autoConfigurable = matcher.matches();
        if (this.autoConfigurable) {
            this.persistence = matcher.group(1);
            this.tenant = matcher.group(2);
            this.namespace = matcher.group(3);
            this.topic = matcher.group(4);
        }
    }

    public String getPersistence() {
        return this.persistence;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isAutoConfigurable() {
        return this.autoConfigurable;
    }
}

