/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.printer;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class PrinterEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":hostname:port/printername";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "lpr".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "hostname", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "printername", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(14);
        props.add("orientation");
        props.add("sendToPrinter");
        props.add("mimeType");
        props.add("mediaTray");
        props.add("docFlavor");
        props.add("printerPrefix");
        props.add("flavor");
        props.add("mediaSize");
        props.add("hostname");
        props.add("lazyStartProducer");
        props.add("copies");
        props.add("port");
        props.add("sides");
        props.add("printername");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

