/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Signature;
import javax.crypto.KeyGenerator;
import org.apache.camel.CamelContext;
import org.apache.camel.component.pqc.PQCComponent;
import org.apache.camel.component.pqc.PQCConfiguration;
import org.apache.camel.component.pqc.PQCOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class PQCComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private PQCConfiguration getOrCreateConfiguration(PQCComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new PQCConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        PQCComponent target = (PQCComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)PQCComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((PQCConfiguration)PQCComponentConfigurer.property((CamelContext)camelContext, PQCConfiguration.class, (Object)value));
                return true;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                target.setHealthCheckConsumerEnabled((Boolean)PQCComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                target.setHealthCheckProducerEnabled((Boolean)PQCComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyencapsulationalgorithm": 
            case "keyEncapsulationAlgorithm": {
                this.getOrCreateConfiguration(target).setKeyEncapsulationAlgorithm((String)PQCComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keygenerator": 
            case "keyGenerator": {
                this.getOrCreateConfiguration(target).setKeyGenerator((KeyGenerator)PQCComponentConfigurer.property((CamelContext)camelContext, KeyGenerator.class, (Object)value));
                return true;
            }
            case "keypair": 
            case "keyPair": {
                this.getOrCreateConfiguration(target).setKeyPair((KeyPair)PQCComponentConfigurer.property((CamelContext)camelContext, KeyPair.class, (Object)value));
                return true;
            }
            case "keypairalias": 
            case "keyPairAlias": {
                this.getOrCreateConfiguration(target).setKeyPairAlias((String)PQCComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystore": 
            case "keyStore": {
                this.getOrCreateConfiguration(target).setKeyStore((KeyStore)PQCComponentConfigurer.property((CamelContext)camelContext, KeyStore.class, (Object)value));
                return true;
            }
            case "keystorepassword": 
            case "keyStorePassword": {
                this.getOrCreateConfiguration(target).setKeyStorePassword((String)PQCComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)PQCComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((PQCOperations)((Object)PQCComponentConfigurer.property((CamelContext)camelContext, PQCOperations.class, (Object)value)));
                return true;
            }
            case "signaturealgorithm": 
            case "signatureAlgorithm": {
                this.getOrCreateConfiguration(target).setSignatureAlgorithm((String)PQCComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signer": {
                this.getOrCreateConfiguration(target).setSigner((Signature)PQCComponentConfigurer.property((CamelContext)camelContext, Signature.class, (Object)value));
                return true;
            }
            case "storeextractedsecretkeyasheader": 
            case "storeExtractedSecretKeyAsHeader": {
                this.getOrCreateConfiguration(target).setStoreExtractedSecretKeyAsHeader((Boolean)PQCComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "symmetrickeyalgorithm": 
            case "symmetricKeyAlgorithm": {
                this.getOrCreateConfiguration(target).setSymmetricKeyAlgorithm((String)PQCComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "symmetrickeylength": 
            case "symmetricKeyLength": {
                this.getOrCreateConfiguration(target).setSymmetricKeyLength((Integer)PQCComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"keyGenerator", "keyPair", "keyStore", "signer"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return PQCConfiguration.class;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return Boolean.TYPE;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return Boolean.TYPE;
            }
            case "keyencapsulationalgorithm": 
            case "keyEncapsulationAlgorithm": {
                return String.class;
            }
            case "keygenerator": 
            case "keyGenerator": {
                return KeyGenerator.class;
            }
            case "keypair": 
            case "keyPair": {
                return KeyPair.class;
            }
            case "keypairalias": 
            case "keyPairAlias": {
                return String.class;
            }
            case "keystore": 
            case "keyStore": {
                return KeyStore.class;
            }
            case "keystorepassword": 
            case "keyStorePassword": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return PQCOperations.class;
            }
            case "signaturealgorithm": 
            case "signatureAlgorithm": {
                return String.class;
            }
            case "signer": {
                return Signature.class;
            }
            case "storeextractedsecretkeyasheader": 
            case "storeExtractedSecretKeyAsHeader": {
                return Boolean.TYPE;
            }
            case "symmetrickeyalgorithm": 
            case "symmetricKeyAlgorithm": {
                return String.class;
            }
            case "symmetrickeylength": 
            case "symmetricKeyLength": {
                return Integer.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        PQCComponent target = (PQCComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return target.isHealthCheckConsumerEnabled();
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return target.isHealthCheckProducerEnabled();
            }
            case "keyencapsulationalgorithm": 
            case "keyEncapsulationAlgorithm": {
                return this.getOrCreateConfiguration(target).getKeyEncapsulationAlgorithm();
            }
            case "keygenerator": 
            case "keyGenerator": {
                return this.getOrCreateConfiguration(target).getKeyGenerator();
            }
            case "keypair": 
            case "keyPair": {
                return this.getOrCreateConfiguration(target).getKeyPair();
            }
            case "keypairalias": 
            case "keyPairAlias": {
                return this.getOrCreateConfiguration(target).getKeyPairAlias();
            }
            case "keystore": 
            case "keyStore": {
                return this.getOrCreateConfiguration(target).getKeyStore();
            }
            case "keystorepassword": 
            case "keyStorePassword": {
                return this.getOrCreateConfiguration(target).getKeyStorePassword();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "signaturealgorithm": 
            case "signatureAlgorithm": {
                return this.getOrCreateConfiguration(target).getSignatureAlgorithm();
            }
            case "signer": {
                return this.getOrCreateConfiguration(target).getSigner();
            }
            case "storeextractedsecretkeyasheader": 
            case "storeExtractedSecretKeyAsHeader": {
                return this.getOrCreateConfiguration(target).isStoreExtractedSecretKeyAsHeader();
            }
            case "symmetrickeyalgorithm": 
            case "symmetricKeyAlgorithm": {
                return this.getOrCreateConfiguration(target).getSymmetricKeyAlgorithm();
            }
            case "symmetrickeylength": 
            case "symmetricKeyLength": {
                return this.getOrCreateConfiguration(target).getSymmetricKeyLength();
            }
        }
        return null;
    }
}

