/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc;

import java.security.Provider;
import java.security.Security;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pqc.PQCComponent;
import org.apache.camel.component.pqc.PQCConfiguration;
import org.apache.camel.component.pqc.PQCConstants;
import org.apache.camel.component.pqc.PQCProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;

@UriEndpoint(firstVersion="4.12.0", scheme="pqc", title="PQC Algorithms", syntax="pqc:label", producerOnly=true, category={Category.SECURITY}, headersClass=PQCConstants.class)
public class PQCEndpoint
extends DefaultEndpoint {
    @UriParam
    private PQCConfiguration configuration;

    public PQCEndpoint(String uri, Component component, PQCConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public PQCComponent getComponent() {
        return (PQCComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new PQCProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastlePQCProvider());
        }
    }

    public void doStop() throws Exception {
        if (Security.getProvider("BC") != null) {
            Security.removeProvider("BC");
        }
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) != null) {
            Security.removeProvider(BouncyCastlePQCProvider.PROVIDER_NAME);
        }
        super.doStop();
    }

    public PQCConfiguration getConfiguration() {
        return this.configuration;
    }
}

