/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.plc4x.Plc4XEndpoint;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="plc4x")
public class Plc4XComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plc4XComponent.class);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Integer period;
        String trigger;
        Plc4XEndpoint endpoint = new Plc4XEndpoint(uri, (Component)this);
        LinkedHashMap<String, String> tags = (LinkedHashMap<String, String>)this.getAndRemoveOrResolveReferenceParameter(parameters, "tags", Map.class);
        Map map = PropertiesHelper.extractProperties(parameters, (String)"tag.");
        if (map != null) {
            if (tags == null) {
                tags = new LinkedHashMap<String, String>();
            }
            for (Map.Entry me : map.entrySet()) {
                tags.put((String)me.getKey(), me.getValue().toString());
            }
        }
        if (tags != null) {
            endpoint.setTags((Map<String, String>)tags);
        }
        if ((trigger = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "trigger", String.class)) != null) {
            endpoint.setTrigger(trigger);
        }
        if ((period = (Integer)this.getAndRemoveOrResolveReferenceParameter(parameters, "period", Integer.class)) != null) {
            endpoint.setPeriod(period);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) {
        Plc4XEndpoint plc4XEndpoint = (Plc4XEndpoint)endpoint;
        plc4XEndpoint.setDriver(remaining.split(":")[0]);
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        if (parameters != null && !parameters.isEmpty()) {
            Map param = parameters;
            if (optionPrefix != null) {
                param = PropertiesHelper.extractProperties(parameters, (String)optionPrefix);
            }
            if (parameters.size() > 0) {
                LOGGER.info("{} parameters will be passed to the PLC Driver", (Object)param);
            }
        }
    }
}

