/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.cookie;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.cookie.CookieConfiguration;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class CookieConfigurationConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CookieConfiguration target = (CookieConfiguration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "cookiedomain": 
            case "cookieDomain": {
                target.setCookieDomain((String)CookieConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cookiehttponly": 
            case "cookieHttpOnly": {
                target.setCookieHttpOnly((Boolean)CookieConfigurationConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cookiemaxage": 
            case "cookieMaxAge": {
                target.setCookieMaxAge((Long)CookieConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "cookiepath": 
            case "cookiePath": {
                target.setCookiePath((String)CookieConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "cookiesamesite": 
            case "cookieSameSite": {
                target.setCookieSameSite((CookieConfiguration.CookieSameSite)((Object)CookieConfigurationConfigurer.property((CamelContext)camelContext, CookieConfiguration.CookieSameSite.class, (Object)value)));
                return true;
            }
            case "cookiesecure": 
            case "cookieSecure": {
                target.setCookieSecure((Boolean)CookieConfigurationConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "cookiedomain": 
            case "cookieDomain": {
                return String.class;
            }
            case "cookiehttponly": 
            case "cookieHttpOnly": {
                return Boolean.TYPE;
            }
            case "cookiemaxage": 
            case "cookieMaxAge": {
                return Long.class;
            }
            case "cookiepath": 
            case "cookiePath": {
                return String.class;
            }
            case "cookiesamesite": 
            case "cookieSameSite": {
                return CookieConfiguration.CookieSameSite.class;
            }
            case "cookiesecure": 
            case "cookieSecure": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CookieConfiguration target = (CookieConfiguration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "cookiedomain": 
            case "cookieDomain": {
                return target.getCookieDomain();
            }
            case "cookiehttponly": 
            case "cookieHttpOnly": {
                return target.isCookieHttpOnly();
            }
            case "cookiemaxage": 
            case "cookieMaxAge": {
                return target.getCookieMaxAge();
            }
            case "cookiepath": 
            case "cookiePath": {
                return target.getCookiePath();
            }
            case "cookiesamesite": 
            case "cookieSameSite": {
                return target.getCookieSameSite();
            }
            case "cookiesecure": 
            case "cookieSecure": {
                return target.isCookieSecure();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("CookieDomain", String.class);
        map.put("CookieHttpOnly", Boolean.TYPE);
        map.put("CookieMaxAge", Long.class);
        map.put("CookiePath", String.class);
        map.put("CookieSameSite", CookieConfiguration.CookieSameSite.class);
        map.put("CookieSecure", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

