/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.Locale;
import java.util.Objects;
import org.apache.camel.Consumer;
import org.apache.camel.util.StringHelper;

public class HttpEndpointModel
implements Comparable<HttpEndpointModel> {
    private final String uri;
    private String verbs;
    private final Consumer consumer;

    public HttpEndpointModel(String uri) {
        this(uri, null, null);
    }

    public HttpEndpointModel(String uri, String verbs) {
        this(uri, verbs, null);
    }

    public HttpEndpointModel(String uri, String verbs, Consumer consumer) {
        this.uri = uri;
        this.addVerb(verbs);
        this.consumer = consumer;
    }

    public String getUri() {
        return this.uri;
    }

    public String getVerbs() {
        return this.verbs;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void addVerb(String verb) {
        if (verb != null) {
            if (this.verbs == null) {
                this.verbs = "";
            }
            if (!StringHelper.containsIgnoreCase((String)this.verbs, (String)verb)) {
                if (!this.verbs.isEmpty()) {
                    this.verbs = this.verbs + ",";
                }
                this.verbs = this.verbs + verb.toUpperCase(Locale.US);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpEndpointModel that = (HttpEndpointModel)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    @Override
    public int compareTo(HttpEndpointModel o) {
        return this.uri.compareTo(o.uri);
    }
}

