/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main.authentication;

import io.vertx.core.Vertx;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.web.handler.BasicAuthHandler;
import org.apache.camel.component.platform.http.main.authentication.MainAuthenticationConfigurer;
import org.apache.camel.component.platform.http.vertx.auth.AuthenticationConfig;
import org.apache.camel.main.HttpManagementServerConfigurationProperties;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.util.ObjectHelper;

public class BasicAuthenticationConfigurer
implements MainAuthenticationConfigurer {
    @Override
    public void configureAuthentication(AuthenticationConfig authenticationConfig, HttpServerConfigurationProperties properties) {
        String path;
        String authPropertiesFileName = properties.getBasicPropertiesFile();
        String string = path = ObjectHelper.isNotEmpty((String)properties.getAuthenticationPath()) ? properties.getAuthenticationPath() : properties.getPath();
        if ("/".equals(path)) {
            path = "/*";
        }
        AuthenticationConfig.AuthenticationConfigEntry entry = new AuthenticationConfig.AuthenticationConfigEntry();
        entry.setPath(path);
        entry.setAuthenticationHandlerFactory(BasicAuthHandler::create);
        entry.setAuthenticationProviderFactory(vertx -> PropertyFileAuthentication.create((Vertx)vertx, (String)authPropertiesFileName));
        authenticationConfig.getEntries().add(entry);
        authenticationConfig.setEnabled(true);
    }

    @Override
    public void configureAuthentication(AuthenticationConfig authenticationConfig, HttpManagementServerConfigurationProperties properties) {
        String path;
        String authPropertiesFileName = properties.getBasicPropertiesFile();
        String string = path = ObjectHelper.isNotEmpty((String)properties.getAuthenticationPath()) ? properties.getAuthenticationPath() : properties.getPath();
        if ("/".equals(path)) {
            path = "/*";
        }
        AuthenticationConfig.AuthenticationConfigEntry entry = new AuthenticationConfig.AuthenticationConfigEntry();
        entry.setPath(path);
        entry.setAuthenticationHandlerFactory(BasicAuthHandler::create);
        entry.setAuthenticationProviderFactory(vertx -> PropertyFileAuthentication.create((Vertx)vertx, (String)authPropertiesFileName));
        authenticationConfig.getEntries().add(entry);
        authenticationConfig.setEnabled(true);
    }
}

