/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pinecone;

import io.pinecone.clients.Pinecone;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pinecone.PineconeVectorDbConfiguration;
import org.apache.camel.component.pinecone.PineconeVectorDbHeaders;
import org.apache.camel.component.pinecone.PineconeVectorDbProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.6.0", scheme="pinecone", title="Pinecone", syntax="pinecone:collection", producerOnly=true, category={Category.DATABASE, Category.AI}, headersClass=PineconeVectorDbHeaders.class)
public class PineconeVectorDbEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The collection Name")
    private final String collection;
    @UriParam
    private PineconeVectorDbConfiguration configuration;
    private Pinecone client;

    public PineconeVectorDbEndpoint(String endpointUri, Component component, String collection, PineconeVectorDbConfiguration configuration) {
        super(endpointUri, component);
        this.collection = collection;
        this.configuration = configuration;
    }

    public PineconeVectorDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getCollection() {
        return this.collection;
    }

    public Pinecone getClient() {
        this.lock.lock();
        try {
            if (this.client == null) {
                this.client = this.configuration.getClient();
                if (this.client == null) {
                    this.client = this.createClient();
                }
            }
            Pinecone pinecone = this.client;
            return pinecone;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Producer createProducer() throws Exception {
        return new PineconeVectorDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
    }

    private Pinecone createClient() {
        boolean tls = this.configuration.isTls();
        Pinecone.Builder builder = new Pinecone.Builder(this.configuration.getToken());
        if (this.getConfiguration().getHost() != null) {
            builder = builder.withHost(this.getConfiguration().getHost());
        }
        if (!tls) {
            builder = builder.withTlsEnabled(tls);
        }
        if (this.getConfiguration().getProxyHost() != null && this.getConfiguration().getProxyPort() != null) {
            builder = builder.withProxy(this.getConfiguration().getProxyHost(), this.getConfiguration().getProxyPort().intValue());
        }
        return builder.build();
    }
}

