/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pgevent;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class PgEventEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/database/channel";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "pgevent".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", "localhost", false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", "5432", false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "database", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "channel", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(15);
        props.add("bridgeErrorHandler");
        props.add("channel");
        props.add("database");
        props.add("datasource");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("host");
        props.add("lazyStartProducer");
        props.add("pass");
        props.add("port");
        props.add("reconnectDelay");
        props.add("user");
        props.add("workerPool");
        props.add("workerPoolCoreSize");
        props.add("workerPoolMaxSize");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("pass");
        secretProps.add("user");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

