/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl.component;

import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.commons.lang3.StringUtils;

public final class ComponentDslInnerBuilderGenerator {
    private static final String BUILDER_SUFFIX = "Builder";
    private final JavaClass javaClass;
    private final ComponentModel componentModel;

    private ComponentDslInnerBuilderGenerator(JavaClass javaClass, ComponentModel componentModel) {
        this.javaClass = javaClass;
        this.componentModel = componentModel;
        this.generateJavaClass();
    }

    public static ComponentDslInnerBuilderGenerator generateClass(JavaClass javaClass, ComponentModel componentModel) {
        return new ComponentDslInnerBuilderGenerator(javaClass, componentModel);
    }

    public static String getExpectedGeneratedInterfaceName(ComponentModel componentModel) {
        return DslHelper.generateComponentBuilderClassName(componentModel, BUILDER_SUFFIX);
    }

    public String getGeneratedInterfaceName() {
        return ComponentDslInnerBuilderGenerator.getExpectedGeneratedInterfaceName(this.componentModel);
    }

    private void generateJavaClass() {
        this.setJavaDoc();
        this.setClassNameAndType();
        this.setFluentMethodsFromComponentOptions();
    }

    private void setJavaDoc() {
        this.javaClass.getJavaDoc().setText("Builder for the " + this.componentModel.getTitle() + " component.");
    }

    private void setClassNameAndType() {
        this.javaClass.setName(this.getGeneratedInterfaceName()).setPackagePrivate().setClass(false).extendSuperType(String.format("ComponentBuilder<%s>", this.componentModel.getShortJavaType()));
    }

    private void setFluentMethodsFromComponentOptions() {
        this.componentModel.getComponentOptions().forEach(componentOptionModel -> {
            Method method = this.javaClass.addMethod();
            method.setDefault().setReturnType(this.getGeneratedInterfaceName()).setName(StringUtils.uncapitalize((String)componentOptionModel.getName())).addParameter(componentOptionModel.getJavaType(), componentOptionModel.getName()).setBody(new String[]{String.format("doSetProperty(\"%s\", %s);", componentOptionModel.getName(), componentOptionModel.getName()), "return this;"});
            if (componentOptionModel.isDeprecated()) {
                method.addAnnotation(Deprecated.class);
            }
            Object doc = this.generateOptionDescription((ComponentModel.ComponentOptionModel)componentOptionModel);
            doc = JavadocHelper.xmlEncode((String)doc);
            doc = (String)doc + "\n\n@param " + componentOptionModel.getName() + " the value to set";
            doc = (String)doc + "\n@return the dsl builder\n";
            method.getJavaDoc().setText((String)doc);
        });
    }

    private String generateOptionDescription(ComponentModel.ComponentOptionModel componentOptionModel) {
        Object desc = JavadocHelper.xmlEncode((String)componentOptionModel.getDescription());
        if (!((String)desc).endsWith(".")) {
            desc = (String)desc + ".";
        }
        if (componentOptionModel.isSupportFileReference()) {
            desc = (String)desc + "\n";
            desc = (String)desc + "\nThis option can also be loaded from an existing file, by prefixing with file: or classpath: followed by the location of the file.";
        }
        desc = (String)desc + "\n";
        desc = (String)desc + "\nThe option is a: <code>" + JavadocHelper.xmlEncode((String)componentOptionModel.getJavaType()) + "</code> type.";
        desc = (String)desc + "\n";
        if ("parameter".equals(componentOptionModel.getKind()) && componentOptionModel.isRequired()) {
            desc = (String)desc + "\nRequired: true";
        }
        if (componentOptionModel.getDefaultValue() != null) {
            String text = JavadocHelper.xmlEncode((String)componentOptionModel.getDefaultValue().toString());
            desc = (String)desc + "\nDefault: " + text;
        }
        desc = (String)desc + "\nGroup: " + componentOptionModel.getGroup();
        return desc;
    }
}

