/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.PackageComponentMojo;
import org.apache.camel.maven.packaging.PackageDataFormatMojo;
import org.apache.camel.maven.packaging.PackageLanguageMojo;
import org.apache.camel.maven.packaging.PackageOtherMojo;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="prepare-components", threadSafe=true)
public class PrepareComponentMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File configurerSourceOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File configurerResourceOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File componentOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File dataFormatOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File languageOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File otherOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File schemaOutDir;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${camel-prepare-component}")
    protected boolean prepareComponent;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.configurerSourceOutDir = new File(project.getBasedir(), "src/generated/java");
        this.otherOutDir = this.schemaOutDir = new File(project.getBasedir(), "src/generated/resources");
        this.languageOutDir = this.schemaOutDir;
        this.dataFormatOutDir = this.schemaOutDir;
        this.componentOutDir = this.schemaOutDir;
        this.configurerResourceOutDir = this.schemaOutDir;
        this.buildDir = new File(project.getBuild().getDirectory());
        this.prepareComponent = Boolean.parseBoolean(project.getProperties().getProperty("camel-prepare-component", "false"));
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Object syncComponents;
        if (!this.prepareComponent) {
            return;
        }
        int count = 0;
        count += new PackageComponentMojo(this.getLog(), this.project, this.projectHelper, this.buildDir, this.componentOutDir, this.buildContext).prepareComponent();
        count += new PackageDataFormatMojo(this.getLog(), this.project, this.projectHelper, this.dataFormatOutDir, this.configurerSourceOutDir, this.configurerResourceOutDir, this.schemaOutDir, this.buildContext).prepareDataFormat();
        if ((count += new PackageLanguageMojo(this.getLog(), this.project, this.projectHelper, this.buildDir, this.languageOutDir, this.schemaOutDir, this.buildContext).prepareLanguage()) == 0 && new File(this.project.getBasedir(), "src/main/java").isDirectory()) {
            new PackageOtherMojo(this.getLog(), this.project, this.projectHelper, this.otherOutDir, this.schemaOutDir, this.buildContext).prepareOthers();
            count = 1;
        } else if (count == 0 && new File(this.project.getBasedir(), "src/main/kotlin").isDirectory()) {
            new PackageOtherMojo(this.getLog(), this.project, this.projectHelper, this.otherOutDir, this.schemaOutDir, this.buildContext).prepareOthers();
            count = 1;
        }
        Object syncParent = syncComponents = this.project.getContextValue("syncPomFile");
        if (!"false".equals(syncComponents)) {
            boolean components = PrepareComponentMojo.isParentArtifact(this.project, "components");
            syncComponents = components ? "true" : "false";
            boolean core = PrepareComponentMojo.isParentArtifact(this.project, "core");
            syncParent = core ? "false" : "true";
        }
        if (count > 0) {
            if ("true".equals(syncParent)) {
                boolean dsl = PrepareComponentMojo.isParentArtifact(this.project, "dsl");
                String token = dsl ? "dsl" : "components";
                this.syncParentPomFile(token);
            }
            if ("true".equals(syncComponents)) {
                this.syncAllComponentsPomFile();
            }
        }
    }

    private static boolean isParentArtifact(MavenProject project, String name) {
        Artifact artifact;
        if (project != null && (artifact = project.getParentArtifact()) != null) {
            if (name.equals(artifact.getArtifactId())) {
                return true;
            }
            MavenProject parent = project.getParent();
            return PrepareComponentMojo.isParentArtifact(parent, name);
        }
        return false;
    }

    private void syncParentPomFile(String token) throws MojoExecutionException {
        Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"parent").toPath();
        Path pomFile = root.resolve("pom.xml");
        String startDependenciesMarker = "<!-- camel " + token + ": START -->";
        String endDependenciesMarker = "<!-- camel " + token + ": END -->";
        if (!Files.isRegularFile(pomFile, new LinkOption[0])) {
            throw new MojoExecutionException("Pom file " + pomFile + " does not exist");
        }
        try {
            String pomText = PackageHelper.loadText((Path)pomFile);
            String before = Strings.before((String)pomText, (String)startDependenciesMarker);
            String after = Strings.after((String)pomText, (String)endDependenciesMarker);
            String between = pomText.substring(before.length(), pomText.length() - after.length());
            Pattern pattern = Pattern.compile("<dependency>\\s*<groupId>(?<groupId>.*)</groupId>\\s*<artifactId>(?<artifactId>.*)</artifactId>\\s*<version>(?<version>.*)</version>");
            Matcher matcher = pattern.matcher(between);
            TreeSet<MavenGav> dependencies = new TreeSet<MavenGav>();
            while (matcher.find()) {
                String v = matcher.groupCount() > 2 ? matcher.group(3) : this.project.getVersion();
                MavenGav gav = new MavenGav(matcher.group(1), matcher.group(2), v, null);
                dependencies.add(gav);
            }
            dependencies.add(new MavenGav(this.project.getGroupId(), this.project.getArtifactId(), "${project.version}", this.project.getArtifact().getType()));
            String s = dependencies.stream().map(g -> g.asString("            ")).collect(Collectors.joining("\n"));
            String updatedPom = before + startDependenciesMarker + "\n" + s + "\n        " + endDependenciesMarker + after;
            PrepareComponentMojo.updateResource(this.buildContext, pomFile, updatedPom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + pomFile + " Reason: " + e, (Exception)e);
        }
    }

    private void syncAllComponentsPomFile() throws MojoExecutionException {
        Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"catalog/camel-allcomponents").toPath();
        Path pomFile = root.resolve("pom.xml");
        String startDependenciesMarker = "<dependencies>";
        String endDependenciesMarker = "</dependencies>";
        if (!Files.isRegularFile(pomFile, new LinkOption[0])) {
            throw new MojoExecutionException("Pom file " + pomFile + " does not exist");
        }
        try {
            String pomText = PackageHelper.loadText((Path)pomFile);
            String before = Strings.before((String)pomText, (String)"<dependencies>");
            String after = Strings.after((String)pomText, (String)"</dependencies>");
            String between = pomText.substring(before.length(), pomText.length() - after.length());
            Pattern pattern = Pattern.compile("<dependency>\\s*<groupId>(?<groupId>.*)</groupId>\\s*<artifactId>(?<artifactId>.*)</artifactId>");
            Matcher matcher = pattern.matcher(between);
            TreeSet<MavenGav> dependencies = new TreeSet<MavenGav>();
            while (matcher.find()) {
                MavenGav gav = new MavenGav(matcher.group(1), matcher.group(2), "${project.version}", null);
                dependencies.add(gav);
            }
            dependencies.add(new MavenGav(this.project.getGroupId(), this.project.getArtifactId(), "${project.version}", null));
            String s = dependencies.stream().filter(g -> !g.artifactId.contains("-maven-plugin")).map(g -> g.asString("        ")).collect(Collectors.joining("\n"));
            String updatedPom = before + "<dependencies>\n" + s + "\n    </dependencies>" + after;
            PrepareComponentMojo.updateResource(this.buildContext, pomFile, updatedPom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + pomFile + " Reason: " + e, (Exception)e);
        }
    }

    private static class MavenGav
    implements Comparable<MavenGav> {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String type;

        public MavenGav(String groupId, String artifactId, String version, String type) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenGav mavenGav = (MavenGav)o;
            if (!this.groupId.equals(mavenGav.groupId)) {
                return false;
            }
            if (!this.artifactId.equals(mavenGav.artifactId)) {
                return false;
            }
            if (!this.version.equals(mavenGav.version)) {
                return false;
            }
            return Objects.equals(this.type, mavenGav.type);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            result = 31 * result + this.version.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

        public String asString(String pad) {
            StringBuilder sb = new StringBuilder();
            sb.append(pad).append("<dependency>\n");
            sb.append(pad).append("    <groupId>").append(this.groupId).append("</groupId>\n");
            sb.append(pad).append("    <artifactId>").append(this.artifactId).append("</artifactId>\n");
            sb.append(pad).append("    <version>").append(this.version).append("</version>\n");
            if (this.type != null) {
                sb.append(pad).append("    <type>").append(this.type).append("</type>\n");
            }
            sb.append(pad).append("</dependency>");
            return sb.toString();
        }

        @Override
        public int compareTo(MavenGav o) {
            int n = this.groupId.compareTo(o.groupId);
            if (n == 0) {
                n = this.artifactId.compareTo(o.artifactId);
            }
            if (n == 0) {
                n = this.version.compareTo(o.version);
            }
            return n;
        }
    }
}

