/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    public static final String GENERATED_MSG = "Generated by camel build tools - do NOT edit this file!";
    public static final String NL = "\n";
    private static final Map<String, Class<?>> KNOWN_CLASSES_CACHE = new ConcurrentHashMap();
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected BuildContext buildContext;
    private DynamicClassLoader projectClassLoader;

    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.project = project;
        this.projectHelper = projectHelper;
        this.buildContext = buildContext;
        this.execute();
    }

    protected void addResourceDirectory(Path path) {
        this.projectHelper.addResource(this.project, path.toString(), Collections.singletonList("**/*"), Collections.emptyList());
    }

    public void refresh(Path file) {
        AbstractGeneratorMojo.refresh(this.buildContext, file);
    }

    protected boolean updateResource(Path dir, String fileName, String data) {
        boolean updated = AbstractGeneratorMojo.updateResource(this.buildContext, dir.resolve(fileName), data);
        if (!fileName.endsWith(".java")) {
            Path outputDir = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
            updated |= AbstractGeneratorMojo.updateResource(this.buildContext, outputDir.resolve(fileName), data);
        }
        return updated;
    }

    protected String createProperties(String key, String val) {
        return AbstractGeneratorMojo.createProperties(this.project, key, val);
    }

    public static String createProperties(MavenProject project, String key, String val) {
        StringBuilder properties = new StringBuilder(256);
        properties.append("# ").append(GENERATED_MSG).append(NL);
        properties.append(key).append("=").append(val).append(NL);
        properties.append("groupId=").append(project.getGroupId()).append(NL);
        properties.append("artifactId=").append(project.getArtifactId()).append(NL);
        properties.append("version=").append(project.getVersion()).append(NL);
        properties.append("projectName=").append(project.getName()).append(NL);
        if (project.getDescription() != null) {
            properties.append("projectDescription=").append(project.getDescription()).append(NL);
        }
        String data = properties.toString();
        return data;
    }

    public static void refresh(BuildContext buildContext, Path file) {
        if (buildContext != null) {
            buildContext.refresh(file.toFile());
        }
    }

    public static boolean updateResource(BuildContext buildContext, Path out, String data) {
        try {
            if (FileUtil.updateFile((Path)out, (String)data)) {
                AbstractGeneratorMojo.refresh(buildContext, out);
                return true;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return false;
    }

    public static boolean haveResourcesChanged(Log log, MavenProject project, BuildContext buildContext, String suffix) {
        String baseDir = project.getBasedir().getAbsolutePath();
        for (Resource r : project.getBuild().getResources()) {
            File file = new File(r.getDirectory());
            if (file.isAbsolute()) {
                file = new File(r.getDirectory().substring(baseDir.length() + 1));
            }
            if (log.isDebugEnabled()) {
                String path = file.getPath() + "/" + suffix;
                log.debug((CharSequence)("Checking  if " + path + " (" + r.getDirectory() + "/" + suffix + ") has changed."));
            }
            if (!buildContext.hasDelta(new File(file, suffix))) continue;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Indeed " + suffix + " has changed."));
            }
            return true;
        }
        return false;
    }

    protected static <T> Supplier<T> cache(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }

    protected Class<?> loadClass(String loadClassName) {
        return KNOWN_CLASSES_CACHE.computeIfAbsent(loadClassName, k -> this.doLoadClass(loadClassName));
    }

    private Class<?> doLoadClass(String loadClassName) {
        Class<?> optionClass;
        String org = loadClassName;
        while (true) {
            try {
                optionClass = this.getProjectClassLoader().loadClass((String)loadClassName);
            }
            catch (ClassNotFoundException e) {
                int dotIndex = ((String)loadClassName).lastIndexOf(46);
                if (dotIndex == -1) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Failed to load class: " + (String)loadClassName));
                    }
                    throw new NoClassDefFoundError(org);
                }
                loadClassName = ((String)loadClassName).substring(0, dotIndex) + "$" + ((String)loadClassName).substring(dotIndex + 1);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Relocating previous class name for loading as: " + (String)loadClassName));
                continue;
            }
            break;
        }
        return optionClass;
    }

    protected final DynamicClassLoader getProjectClassLoader() {
        if (this.projectClassLoader == null) {
            try {
                this.projectClassLoader = DynamicClassLoader.createDynamicClassLoader(this.project.getCompileClasspathElements());
            }
            catch (DependencyResolutionRequiredException e) {
                throw new RuntimeException("Unable to create project classloader", e);
            }
        }
        return this.projectClassLoader;
    }

    protected boolean isJsonFile(Path p, BasicFileAttributes a) {
        return a.isRegularFile() && p.toFile().getName().endsWith(".json");
    }

    static {
        KNOWN_CLASSES_CACHE.put("Byte", Byte.class);
        KNOWN_CLASSES_CACHE.put("Boolean", Boolean.class);
        KNOWN_CLASSES_CACHE.put("Date", Date.class);
        KNOWN_CLASSES_CACHE.put("Double", Double.class);
        KNOWN_CLASSES_CACHE.put("Duration", Duration.class);
        KNOWN_CLASSES_CACHE.put("String", String.class);
        KNOWN_CLASSES_CACHE.put("Integer", Integer.class);
        KNOWN_CLASSES_CACHE.put("Long", Long.class);
        KNOWN_CLASSES_CACHE.put("File", File.class);
        KNOWN_CLASSES_CACHE.put("Object", Object.class);
        KNOWN_CLASSES_CACHE.put("int", Integer.TYPE);
        KNOWN_CLASSES_CACHE.put("long", Long.TYPE);
        KNOWN_CLASSES_CACHE.put("boolean", Boolean.TYPE);
    }
}

