/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-legal", threadSafe=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class PackageLegalMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File legalOutDir;

    @Inject
    public PackageLegalMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.legalOutDir == null) {
            this.legalOutDir = new File(this.project.getBuild().getOutputDirectory());
        }
        this.processLegal(this.legalOutDir.toPath());
    }

    public void processLegal(Path legalOutDir) throws MojoExecutionException {
        if (!"org.apache.camel".equals(this.project.getGroupId())) {
            return;
        }
        boolean exists = new File("src/main/resources/META-INF/LICENSE.txt").exists();
        if (!exists) {
            try (InputStream isLicense = ((Object)((Object)this)).getClass().getResourceAsStream("/camel-LICENSE.txt");){
                String license = IOUtils.toString((InputStream)isLicense, (Charset)StandardCharsets.UTF_8);
                this.updateResource(legalOutDir, "META-INF/LICENSE.txt", license);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write legal files. Reason: " + String.valueOf(e), (Exception)e);
            }
        }
        if (!(exists = new File("src/main/resources/META-INF/NOTICE.txt").exists())) {
            try (InputStream isNotice = ((Object)((Object)this)).getClass().getResourceAsStream("/camel-NOTICE.txt");){
                String notice = IOUtils.toString((InputStream)isNotice, (Charset)StandardCharsets.UTF_8);
                this.updateResource(legalOutDir, "META-INF/NOTICE.txt", notice);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write legal files. Reason: " + String.valueOf(e), (Exception)e);
            }
        }
    }
}

