/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="update-mime-type-helper", threadSafe=true)
public class UpdateMimeTypeHelper
extends AbstractGeneratorMojo {
    private static final String TYPES_START_TOKEN = "// MIME-TYPES: START";
    private static final String TYPES_END_TOKEN = "// MIME-TYPES: END";
    @Parameter(defaultValue="${project.basedir}/src/main/resources/mime-types.txt")
    protected File mimeFile;
    @Parameter(defaultValue="${project.basedir}/")
    protected File baseDir;

    @Inject
    public UpdateMimeTypeHelper(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"core/camel-util");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No core/camel-util folder found, skipping execution");
            return;
        }
        TreeMap<String, String> types = new TreeMap<String, String>();
        types.put("yaml", "text/yaml");
        types.put("yml", "text/yaml");
        try (Stream<String> s = Files.lines(this.mimeFile.toPath());){
            for (String line : s.toList()) {
                String[] parts;
                if ((line = line.trim()).startsWith("#") || line.isBlank() || (parts = line.split("\\s")).length <= 1) continue;
                String mime = parts[0].trim();
                for (int i = 1; i < parts.length; ++i) {
                    String ext = parts[i].trim();
                    if (ext.isBlank()) continue;
                    types.put(ext, mime);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error parsing mime-type: " + this.mimeFile, e);
        }
        this.getLog().info((CharSequence)("There are " + types.size() + " mime-types"));
        try {
            boolean updated = this.updateMimeTypeHelper(camelDir, types);
            if (updated) {
                this.getLog().info((CharSequence)"Updated camel-util/src/main/java/org/apache/camel/util/MimeTypeHelper.java file");
            } else {
                this.getLog().debug((CharSequence)"No changes to camel-util/src/main/java/org/apache/camel/util/MimeTypeHelper.java file");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error updating MimeHelper.java", e);
        }
    }

    private boolean updateMimeTypeHelper(File camelDir, Map<String, String> types) throws Exception {
        File java = new File(camelDir, "src/main/java/org/apache/camel/util/MimeTypeHelper.java");
        Object text = PackageHelper.loadText((File)java);
        String spaces4 = "    ";
        String spaces12 = "            ";
        StringJoiner sb = new StringJoiner("\n");
        for (Map.Entry<String, String> e : types.entrySet()) {
            sb.add(spaces12 + "case \"" + e.getKey() + "\" -> \"" + e.getValue() + "\";");
        }
        String changed = sb.toString();
        String existing = Strings.between((String)text, (String)TYPES_START_TOKEN, (String)TYPES_END_TOKEN);
        if (existing != null) {
            if ((existing = existing.trim()).equals(changed = changed.trim())) {
                return false;
            }
            String before = Strings.before((String)text, (String)TYPES_START_TOKEN);
            String after = Strings.after((String)text, (String)TYPES_END_TOKEN);
            text = before + "// MIME-TYPES: START\n" + spaces12 + changed + "\n" + spaces12 + TYPES_END_TOKEN + after;
            PackageHelper.writeText((File)java, (String)text);
            return true;
        }
        return false;
    }
}

