/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.maven.packaging.UpdateReadmeMojo;
import org.apache.camel.tooling.model.JBangModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.mvel2.templates.TemplateRuntime;

@Mojo(name="prepare-jbang-doc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PrepareCamelJBangDocMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/../../../docs/user-manual/modules/ROOT/pages")
    protected File docDocDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/META-INF/camel-jbang-configuration-metadata.json")
    protected File jbangJsonFile;

    @Inject
    public PrepareCamelJBangDocMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    @Override
    public void execute(MavenProject project) throws MojoFailureException, MojoExecutionException {
        this.docDocDir = new File(project.getBasedir().getParentFile().getParentFile().getParent(), "docs/user-manual/modules/ROOT/pages");
        this.jbangJsonFile = new File(project.getBasedir(), "src/generated/resources/META-INF/camel-main-configuration-metadata.json");
        super.execute(project);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean updated;
        if (!this.jbangJsonFile.exists()) {
            return;
        }
        File file = new File(this.docDocDir, "camel-jbang.adoc");
        boolean exists = file.exists();
        try {
            String json = PackageHelper.loadText((File)this.jbangJsonFile);
            JBangModel model = JsonMapper.generateJBangModel((String)json);
            String options = PrepareCamelJBangDocMojo.evaluateTemplate("jbang-options.mvel", model);
            updated = this.updateOptionsIn(file, "jbang", options);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error preparing jbang docs", (Exception)e);
        }
        if (updated) {
            this.getLog().info((CharSequence)("Updated doc file: " + String.valueOf(file)));
        } else if (exists) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("No changes to doc file: " + String.valueOf(file)));
            }
        } else {
            this.getLog().warn((CharSequence)("No jbang doc file: " + String.valueOf(file)));
        }
    }

    private static String evaluateTemplate(String templateName, JBangModel model) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder(256);
        try (InputStream templateStream = UpdateReadmeMojo.class.getClassLoader().getResourceAsStream(templateName);){
            String template = PackageHelper.loadText((InputStream)templateStream);
            for (JBangModel.JBangGroupModel group : model.getGroups()) {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.put("group", group);
                root.put("options", model.getOptions().stream().filter(o -> o.getName().startsWith(group.getName())).toList());
                String eval = (String)TemplateRuntime.eval((String)template, root, Collections.singletonMap("util", MvelHelper.INSTANCE));
                sb.append(eval);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing mvel template `" + templateName + "`", (Exception)e);
        }
        return sb.toString();
    }

    private boolean updateOptionsIn(File file, String kind, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        String updated = changed.trim();
        try {
            Object text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)("// " + kind + " options: START"), (String)("// " + kind + " options: END"));
            if (existing != null) {
                if ((existing = existing.trim()).equals(updated)) {
                    return false;
                }
                String before = Strings.before((String)text, (String)("// " + kind + " options: START"));
                String after = Strings.after((String)text, (String)("// " + kind + " options: END"));
                text = before + "// " + kind + " options: START\n" + updated + "\n// " + kind + " options: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + String.valueOf(file)));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)("\t// " + kind + " options: START"));
            this.getLog().warn((CharSequence)("\t// " + kind + " options: END"));
            return false;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + String.valueOf(file) + " Reason: " + String.valueOf(e), (Exception)e);
        }
    }
}

