/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.project.MavenProject;

public final class SchemaHelper {
    private SchemaHelper() {
    }

    public static String dashToCamelCase(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        if (text.indexOf(45) == -1) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '-') {
                sb.append(Character.toUpperCase(text.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camelCaseToDash(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder answer = new StringBuilder(text.length());
        Character prev = null;
        char[] arr = text.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            Character next = i < arr.length - 1 ? Character.valueOf(arr[i + 1]) : null;
            if (ch == '-' || ch == '_') {
                answer.append("-");
            } else if (Character.isUpperCase(ch) && prev != null && !Character.isUpperCase(prev.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else if (Character.isUpperCase(ch) && prev != null && next != null && Character.isLowerCase(next.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else {
                answer.append(ch);
            }
            prev = Character.valueOf(ch);
        }
        return answer.toString().toLowerCase(Locale.ENGLISH);
    }

    public static void addModelMetadata(BaseModel<?> model, Metadata metadata) {
        if (metadata == null) {
            return;
        }
        SchemaHelper.addModelMetadata(model, metadata.annotations());
    }

    public static void addModelMetadata(BaseModel<?> model, String key, String value) {
        Map<String, Object> modelMetadata = SchemaHelper.getModelMetadata(model);
        if (!Strings.isNullOrEmpty((String)key) && !Strings.isNullOrEmpty((String)value)) {
            modelMetadata.put(key, value);
        }
    }

    public static void addModelMetadata(BaseModel<?> model, MavenProject project) {
        if (project == null) {
            return;
        }
        String annotations = project.getProperties().getProperty("annotations");
        if (!Strings.isNullOrEmpty((String)annotations)) {
            SchemaHelper.addModelMetadata(model, annotations.split(","));
        }
    }

    public static void addModelMetadata(BaseModel<?> model, String[] annotations) {
        if (annotations == null) {
            return;
        }
        Map<String, Object> modelMetadata = SchemaHelper.getModelMetadata(model);
        for (String annotation : annotations) {
            String key = Strings.before((String)annotation, (String)"=");
            String val = Strings.after((String)annotation, (String)"=");
            if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)val)) continue;
            modelMetadata.put(key, val);
        }
    }

    public static Map<String, Object> getModelMetadata(BaseModel<?> model) {
        TreeMap meta = model.getMetadata();
        if (meta == null) {
            meta = new TreeMap();
            model.setMetadata(meta);
        }
        return meta;
    }
}

