/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.util.regex.Pattern;
import org.apache.camel.maven.packaging.SchemaHelper;
import org.apache.camel.tooling.model.ApiMethodModel;
import org.apache.camel.tooling.model.ApiModel;

public final class MvelHelper {
    public static final MvelHelper INSTANCE = new MvelHelper();
    private static final Pattern CURLY_BRACKET_ESCAPE = Pattern.compile("(\\{[a-zA-Z0-9]+?)\\}");
    private static final Pattern URL_ESCAPE = Pattern.compile("(?<!href=\")(http(:?s)?://|(:?s)?ftp(?:s)?://)");

    private MvelHelper() {
    }

    public static String escape(String raw) {
        if (raw == null) {
            return null;
        }
        String escapedCurlyBrackets = CURLY_BRACKET_ESCAPE.matcher(raw).replaceAll("\\\\$1\\}");
        return URL_ESCAPE.matcher(escapedCurlyBrackets).replaceAll("\\\\$1");
    }

    public static String componentName(String scheme) {
        String text = SchemaHelper.dashToCamelCase(scheme);
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    public static String formatSignature(String signature) {
        signature = signature.replace('$', '.');
        return signature + ";";
    }

    public static String apiMethodAlias(ApiModel api, ApiMethodModel method) {
        String name = method.getName();
        for (String alias : api.getAliases()) {
            int pos = alias.indexOf(61);
            String pattern = alias.substring(0, pos);
            String aliasMethod = alias.substring(pos + 1);
            if (!Pattern.compile(pattern, 2).matcher(name).matches()) continue;
            return aliasMethod;
        }
        return "";
    }

    public static String producerOrConsumer(ApiModel api) {
        if (api.isConsumerOnly()) {
            return "Consumer";
        }
        if (api.isProducerOnly()) {
            return "Producer";
        }
        return "Both";
    }
}

