/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.ReleaseModel;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update-camel-releases", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class UpdateCamelReleasesMojo
extends AbstractGeneratorMojo {
    private static final String GIT_CAMEL_URL = "https://api.github.com/repos/apache/camel-website/contents/content/releases/";
    private static final String GIT_CAMEL_QUARKUS_URL = "https://api.github.com/repos/apache/camel-website/contents/content/releases/q/";
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/releases")
    protected File outDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outDir == null) {
            this.outDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        try {
            this.getLog().info((CharSequence)"Updating Camel release information from camel-website");
            List<String> links = this.fetchCamelReleaseLinks(GIT_CAMEL_URL);
            this.updateCamelRelease("Camel", links, "camel-releases.json");
            links = this.fetchCamelReleaseLinks(GIT_CAMEL_QUARKUS_URL);
            this.updateCamelRelease("Camel Quarkus", links, "camel-quarkus-releases.json");
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void updateCamelRelease(String kind, List<String> links, String fileName) throws Exception {
        List<ReleaseModel> releases = this.processReleases(links);
        releases.sort(Comparator.comparing(ReleaseModel::getVersion));
        this.getLog().info((CharSequence)("Found " + releases.size() + " " + kind + " releases"));
        JsonArray arr = new JsonArray();
        for (ReleaseModel r : releases) {
            JsonObject jo = JsonMapper.asJsonObject((ReleaseModel)r);
            arr.add((Object)jo);
        }
        String json = Jsoner.serialize((Object)arr);
        json = Jsoner.prettyPrint((String)json, (int)4);
        Path path = this.outDir.toPath();
        this.updateResource(path, fileName, json);
        this.addResourceDirectory(path);
    }

    private List<ReleaseModel> processReleases(List<String> urls) throws Exception {
        ArrayList<ReleaseModel> answer = new ArrayList<ReleaseModel>();
        HttpClient hc = HttpClient.newHttpClient();
        for (String url : urls) {
            HttpResponse<String> res = hc.send(HttpRequest.newBuilder(new URI(url)).timeout(Duration.ofSeconds(20L)).build(), HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) continue;
            ReleaseModel model = new ReleaseModel();
            LineNumberReader lr = new LineNumberReader(new StringReader(res.body()));
            String line = lr.readLine();
            while (line != null) {
                if (line.startsWith("date:")) {
                    model.setDate(line.substring(5).trim());
                } else if (line.startsWith("version:")) {
                    model.setVersion(line.substring(8).trim());
                } else if (line.startsWith("eol:")) {
                    model.setEol(line.substring(4).trim());
                } else if (line.startsWith("kind:")) {
                    model.setKind(line.substring(5).trim());
                } else if (line.startsWith("jdk:")) {
                    String s = line.substring(4).trim();
                    if (s.startsWith("[") && s.endsWith("]")) {
                        s = s.substring(1, s.length() - 1);
                    }
                    model.setJdk(s);
                }
                line = lr.readLine();
            }
            if (model.getVersion() == null) continue;
            answer.add(model);
        }
        return answer;
    }

    private List<String> fetchCamelReleaseLinks(String gitUrl) throws Exception {
        String loc;
        ArrayList<String> answer = new ArrayList<String>();
        HttpClient hc = HttpClient.newHttpClient();
        HttpResponse<String> res = hc.send(HttpRequest.newBuilder(new URI(gitUrl)).timeout(Duration.ofSeconds(20L)).build(), HttpResponse.BodyHandlers.ofString());
        if (res.statusCode() == 302 && (loc = (String)res.headers().firstValue("location").orElse(null)) != null) {
            res = hc.send(HttpRequest.newBuilder(new URI(loc)).timeout(Duration.ofSeconds(20L)).build(), HttpResponse.BodyHandlers.ofString());
        }
        if (res.statusCode() == 200) {
            JsonArray root = (JsonArray)Jsoner.deserialize((String)res.body());
            for (Object o : root) {
                String url;
                JsonObject jo = (JsonObject)o;
                String name = jo.getString("name");
                if (name == null || !name.startsWith("release-") || (url = jo.getString("download_url")) == null) continue;
                answer.add(url);
            }
        }
        return answer;
    }
}

