/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl.component;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.json.JsonObject;

public class ComponentsDslMetadataRegistry {
    private final Map<String, ComponentModel> componentsCache;
    private final Set<String> componentsDslFactories;
    private final File metadataFile;

    public ComponentsDslMetadataRegistry(File componentDslDir, File metadataFile) {
        this.componentsCache = this.loadMetadataFileIntoMap(metadataFile);
        this.componentsDslFactories = this.loadComponentsFactoriesFromDir(componentDslDir);
        this.metadataFile = metadataFile;
    }

    private Map<String, ComponentModel> loadMetadataFileIntoMap(File metadataFile) {
        String json = metadataFile.isFile() ? ComponentsDslMetadataRegistry.loadJson(metadataFile) : "{ }";
        JsonObject jsonObject = JsonMapper.deserialize((String)json);
        TreeMap<String, ComponentModel> models = new TreeMap<String, ComponentModel>();
        jsonObject.forEach((jsonKey, jsonValue) -> models.put((String)jsonKey, this.loadModel((JsonObject)jsonValue)));
        return models;
    }

    private ComponentModel loadModel(JsonObject json) {
        ComponentModel model = new ComponentModel();
        JsonMapper.parseComponentModel((JsonObject)json, (ComponentModel)model);
        return model;
    }

    private Set<String> loadComponentsFactoriesFromDir(File componentDir) {
        return DslHelper.loadAllJavaFiles(componentDir).stream().map(file -> Strings.before((String)file.getName(), (String)".")).collect(Collectors.toCollection(TreeSet::new));
    }

    public boolean addComponentToMetadataAndSyncMetadataFile(ComponentModel componentModel, String key) {
        this.componentsCache.put(key, componentModel);
        return this.syncMetadataFile();
    }

    private boolean syncMetadataFile() {
        this.syncMetadataFileWithGeneratedDslComponents();
        return this.writeCacheIntoMetadataFile();
    }

    private void syncMetadataFileWithGeneratedDslComponents() {
        HashSet componentsNamesToRemoveFromCache = new HashSet();
        this.componentsCache.forEach((componentFactoryName, value) -> {
            if (!this.componentsDslFactories.contains(componentFactoryName)) {
                componentsNamesToRemoveFromCache.add(componentFactoryName);
            }
        });
        componentsNamesToRemoveFromCache.forEach(this.componentsCache::remove);
    }

    private boolean writeCacheIntoMetadataFile() {
        JsonObject json = new JsonObject();
        this.componentsCache.forEach((componentKey, componentModel) -> json.put(componentKey, JsonMapper.asJsonObject((ComponentModel)componentModel).get((Object)"component")));
        String jsonText = JsonMapper.serialize((Object)json);
        try {
            return FileUtil.updateFile((Path)this.metadataFile.toPath(), (String)jsonText);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public Map<String, ComponentModel> getComponentCacheFromMemory() {
        return this.componentsCache;
    }

    private static String loadJson(File file) {
        try {
            return PackageHelper.loadText((File)file);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

