/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.util.ReflectionHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    private static final String INCREMENTAL_DATA = "";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected BuildContext buildContext;
    @Component
    private MavenSession session;
    @Parameter(defaultValue="${showStaleFiles}")
    private boolean showStaleFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.isUpToDate(this.project)) {
                this.doExecute();
                this.writeIncrementalInfo(this.project);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Error generating data " + e, (Throwable)e);
        }
    }

    protected abstract void doExecute() throws MojoFailureException, MojoExecutionException;

    protected void invoke(Class<? extends AbstractMojo> mojoClass) throws MojoExecutionException, MojoFailureException {
        this.invoke(mojoClass, null);
    }

    protected void invoke(Class<? extends AbstractMojo> mojoClass, Map<String, Object> parameters) throws MojoExecutionException, MojoFailureException {
        try {
            AbstractMojo mojo = mojoClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            mojo.setLog(this.getLog());
            mojo.setPluginContext(this.getPluginContext());
            if (parameters != null && !parameters.isEmpty()) {
                ReflectionHelper.doWithFields(mojoClass, field -> {
                    for (Map.Entry entry : parameters.entrySet()) {
                        if (!field.getName().equals(entry.getKey())) continue;
                        ReflectionHelper.setField((Field)field, (Object)mojo, entry.getValue());
                    }
                });
            }
            ((AbstractGeneratorMojo)mojo).execute(this.project, this.projectHelper, this.buildContext);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create mojo", (Throwable)e);
        }
    }

    private void writeIncrementalInfo(MavenProject project) throws MojoExecutionException {
        try {
            Path cacheData = this.getIncrementalDataPath(project);
            Files.createDirectories(cacheData.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(cacheData, new OpenOption[0]);){
                w.append(INCREMENTAL_DATA);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error checking manifest uptodate status", (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUpToDate(MavenProject project) throws MojoExecutionException {
        try {
            Path cacheData = this.getIncrementalDataPath(project);
            String prvdata = this.getPreviousRunData(cacheData);
            if (INCREMENTAL_DATA.equals(prvdata)) {
                long lastmod = Files.getLastModifiedTime(cacheData, new LinkOption[0]).toMillis();
                Set stale = Stream.concat(Stream.concat(project.getCompileSourceRoots().stream().map(File::new), Stream.of(new File(project.getBuild().getOutputDirectory()))), project.getArtifacts().stream().map(Artifact::getFile)).flatMap(f -> this.newer(lastmod, (File)f)).collect(Collectors.toSet());
                if (stale.isEmpty()) {
                    this.getLog().info((CharSequence)"Skipping generation, everything is up to date.");
                    return true;
                }
                this.getLog().info((CharSequence)"Stale files detected, re-generating.");
                if (this.showStaleFiles) {
                    this.getLog().info((CharSequence)("Stale files: " + String.join((CharSequence)", ", stale)));
                    return false;
                }
                if (!this.getLog().isDebugEnabled()) return false;
                this.getLog().debug((CharSequence)("Stale files: " + String.join((CharSequence)", ", stale)));
                return false;
            }
            if (prvdata == null) {
                this.getLog().info((CharSequence)"No previous run data found, generating files.");
                return false;
            }
            this.getLog().info((CharSequence)"Configuration changed, re-generating files.");
            return false;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error checking uptodate status", (Exception)e);
        }
    }

    private String getPreviousRunData(Path cacheData) throws IOException {
        if (Files.isRegularFile(cacheData, new LinkOption[0])) {
            return new String(Files.readAllBytes(cacheData), StandardCharsets.UTF_8);
        }
        return null;
    }

    private Path getIncrementalDataPath(MavenProject project) {
        return Paths.get(project.getBuild().getDirectory(), "camel-package-maven-plugin", "org.apache.camel_camel-package-maven-plugin_info_xx");
    }

    private long isRecentlyModifiedFile(Path p) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            if (fileAttributes.isDirectory()) {
                return 0L;
            }
            return fileAttributes.lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Stream<String> newer(long lastmod, File file) {
        Stream<String> stream;
        if (!file.exists()) {
            return Stream.empty();
        }
        BasicFileAttributes fileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        if (fileAttributes.isDirectory()) {
            return Files.walk(file.toPath(), new FileVisitOption[0]).filter(p -> this.isRecentlyModifiedFile((Path)p) > lastmod).map(Path::toString);
        }
        if (!fileAttributes.isRegularFile()) return Stream.empty();
        if (fileAttributes.lastModifiedTime().toMillis() <= lastmod) return Stream.empty();
        if (!file.getName().endsWith(".jar")) return Stream.of(file.toString());
        ZipFile zf = new ZipFile(file);
        try {
            stream = zf.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getLastModifiedTime().toMillis() > lastmod).map(ze -> file + "!" + ze.getName()).collect(Collectors.toList()).stream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        zf.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Error reading zip file: " + file, e);
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        zf.close();
        return stream;
    }
}

