/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.SchemaHelper;
import org.apache.camel.maven.packaging.generics.GenericsUtil;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

@Mojo(name="generate-schema", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class SchemaGeneratorMojo
extends AbstractGeneratorMojo {
    public static final DotName XML_ROOT_ELEMENT = DotName.createSimple((String)XmlRootElement.class.getName());
    public static final DotName XML_TYPE = DotName.createSimple((String)XmlType.class.getName());
    private static final String ONE_OF_TYPE_NAME = "org.apache.camel.model.ExpressionSubElementDefinition";
    private static final String[] ONE_OF_LANGUAGES = new String[]{"org.apache.camel.model.language.ExpressionDefinition", "org.apache.camel.model.language.NamespaceAwareExpression"};
    private static final String[] ONE_OF_INPUTS = new String[]{"org.apache.camel.model.ProcessorDefinition", "org.apache.camel.model.rest.VerbDefinition"};
    private static final String[] ONE_OF_OUTPUTS = new String[]{"org.apache.camel.model.ProcessorDefinition", "org.apache.camel.model.NoOutputDefinition", "org.apache.camel.model.OutputDefinition", "org.apache.camel.model.OutputExpressionNode", "org.apache.camel.model.NoOutputExpressionNode", "org.apache.camel.model.SendDefinition", "org.apache.camel.model.InterceptDefinition", "org.apache.camel.model.WhenDefinition", "org.apache.camel.model.ToDynamicDefinition"};
    private static final String[] ONE_OF_VERBS = new String[]{"org.apache.camel.model.rest.VerbDefinition"};
    private static final String[] ONE_OF_ABSTRACTS = new String[]{"org.apache.camel.model.InterceptDefinition", "org.apache.camel.model.InterceptFromDefinition", "org.apache.camel.model.InterceptSendToEndpointDefinition", "org.apache.camel.model.OnCompletionDefinition", "org.apache.camel.model.OnExceptionDefinition", "org.apache.camel.model.PolicyDefinition", "org.apache.camel.model.SagaDefinition", "org.apache.camel.model.TransactedDefinition"};
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;
    private IndexView indexView;
    private final Map<String, JavaClassSource> sources = new HashMap<String, JavaClassSource>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.classesDirectory == null) {
            this.classesDirectory = new File(this.project.getBuild().getOutputDirectory());
        }
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if (!this.classesDirectory.isDirectory()) {
            return;
        }
        IndexView index = this.getIndex();
        index.getAnnotations(XML_ROOT_ELEMENT);
        Set coreElements = index.getAnnotations(XML_ROOT_ELEMENT).stream().filter(cpa -> cpa.target().kind() == AnnotationTarget.Kind.CLASS).filter(cpa -> cpa.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).filter(cpa -> cpa.target().asClass().name().toString().startsWith("org.apache.camel.model.")).map(cpa -> cpa.target().asClass()).collect(Collectors.toSet());
        if (!coreElements.isEmpty()) {
            this.getLog().info((CharSequence)String.format("Found %d core elements", coreElements.size()));
        }
        for (ClassInfo element : coreElements) {
            this.processModelClass(element);
        }
        Set springElements = index.getAnnotations(XML_ROOT_ELEMENT).stream().filter(cpa -> cpa.target().kind() == AnnotationTarget.Kind.CLASS).filter(cpa -> cpa.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).filter(cpa -> {
            String javaTypeName = cpa.target().asClass().name().toString();
            return javaTypeName.startsWith("org.apache.camel.spring.") || javaTypeName.startsWith("org.apache.camel.core.xml.");
        }).map(cpa -> cpa.target().asClass()).collect(Collectors.toSet());
        if (!springElements.isEmpty()) {
            this.getLog().info((CharSequence)String.format("Found %d spring elements", springElements.size()));
        }
        for (ClassInfo element : springElements) {
            this.processModelClass(element);
        }
    }

    private void processModelClass(ClassInfo element) {
        String name;
        String aName;
        if (Modifier.isAbstract(element.flags())) {
            return;
        }
        if (element.name().toString().equals(ONE_OF_TYPE_NAME)) {
            return;
        }
        AnnotationValue annotationValue = element.classAnnotation(XML_ROOT_ELEMENT).value("name");
        String string = aName = annotationValue != null ? annotationValue.asString() : null;
        if (Strings.isNullOrEmpty((String)aName) || "##default".equals(aName)) {
            aName = element.classAnnotation(XML_TYPE).value("name").asString();
        }
        String fileName = Strings.isNullOrEmpty((String)(name = aName)) || "##default".equals(name) ? element.simpleName() + ".json" : name + ".json";
        String javaTypeName = element.name().toString();
        Class<?> classElement = this.loadClass(javaTypeName);
        EipModel eipModel = this.findEipModelProperties(classElement, name);
        TreeSet<EipModel.EipOptionModel> eipOptions = new TreeSet<EipModel.EipOptionModel>(new EipOptionComparator(eipModel));
        this.findClassProperties(eipOptions, classElement, classElement, "", name);
        eipOptions.forEach(arg_0 -> ((EipModel)eipModel).addOption(arg_0));
        eipModel.setAbstractModel(this.hasAbstract(classElement));
        eipModel.setInput(this.hasInput(classElement));
        eipModel.setOutput(this.hasOutput(eipModel));
        if (Strings.isNullOrEmpty((String)eipModel.getTitle())) {
            eipModel.setTitle(Strings.asTitle((String)eipModel.getName()));
        }
        if (eipModel.isOutput()) {
            eipModel.getOptions().removeIf(o -> "outputs".equals(o.getName()));
        }
        String packageName = javaTypeName.substring(0, javaTypeName.lastIndexOf(46));
        String json = JsonMapper.createParameterJsonSchema((EipModel)eipModel);
        this.updateResource(this.resourcesOutputDir.toPath(), packageName.replace('.', '/') + "/" + fileName, json);
    }

    private IndexView getIndex() {
        if (this.indexView == null) {
            this.indexView = PackagePluginUtils.readJandexIndexQuietly(this.project);
        }
        return this.indexView;
    }

    protected EipModel findEipModelProperties(Class<?> classElement, String name) {
        String doc;
        EipModel model = new EipModel();
        model.setJavaType(classElement.getName());
        model.setName(name);
        boolean deprecated = classElement.getAnnotation(Deprecated.class) != null;
        model.setDeprecated(deprecated);
        Metadata metadata = classElement.getAnnotation(Metadata.class);
        if (metadata != null) {
            if (!Strings.isNullOrEmpty((String)metadata.label())) {
                model.setLabel(metadata.label());
            }
            if (!Strings.isNullOrEmpty((String)metadata.title())) {
                model.setTitle(metadata.title());
            }
            if (!Strings.isNullOrEmpty((String)metadata.firstVersion())) {
                model.setFirstVersion(metadata.firstVersion());
            }
        }
        if ((doc = this.getDocComment(classElement)) != null && !Strings.isNullOrEmpty((String)(doc = JavadocHelper.sanitizeDescription((String)doc, (boolean)true)))) {
            model.setDescription(doc);
        }
        return model;
    }

    protected void findClassProperties(Set<EipModel.EipOptionModel> eipOptions, Class<?> originalClassType, Class<?> classElement, String prefix, String modelName) {
        while (true) {
            for (Field fieldElement : classElement.getDeclaredFields()) {
                XmlElementRef elementRef;
                XmlElement element;
                XmlElements elements;
                boolean skip;
                String fieldName = fieldElement.getName();
                XmlAttribute attribute = fieldElement.getAnnotation(XmlAttribute.class);
                if (attribute != null && (skip = this.processAttribute(originalClassType, classElement, fieldElement, fieldName, attribute, eipOptions, prefix))) continue;
                XmlValue value = fieldElement.getAnnotation(XmlValue.class);
                if (value != null) {
                    this.processValue(originalClassType, classElement, fieldElement, fieldName, eipOptions, prefix, modelName);
                }
                if ((elements = fieldElement.getAnnotation(XmlElements.class)) != null) {
                    this.processElements(originalClassType, classElement, elements, fieldElement, eipOptions, prefix);
                }
                if ((element = fieldElement.getAnnotation(XmlElement.class)) != null) {
                    this.processElement(originalClassType, classElement, element, fieldElement, eipOptions, prefix);
                }
                if ((elementRef = fieldElement.getAnnotation(XmlElementRef.class)) == null) continue;
                this.processRoutes(originalClassType, fieldElement, fieldName, eipOptions);
                this.processOutputs(originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRefWhenClauses(originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRests(originalClassType, fieldElement, fieldName, eipOptions);
                this.processVerbs(originalClassType, elementRef, fieldElement, fieldName, eipOptions, prefix);
                this.processRefExpression(originalClassType, classElement, elementRef, fieldElement, fieldName, eipOptions, prefix);
            }
            if ("OptionalIdentifiedDefinition".equals(classElement.getSimpleName())) {
                this.processIdentified(classElement, eipOptions);
            } else if ("RouteDefinition".equals(classElement.getSimpleName())) {
                this.processRoute(classElement, eipOptions);
            }
            Class<?> superclass = classElement.getSuperclass();
            if (superclass == null) break;
            classElement = superclass;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processAttribute(Class<?> originalClassType, Class<?> classElement, Field fieldElement, String fieldName, XmlAttribute attribute, Set<EipModel.EipOptionModel> eipOptions, String prefix) {
        void var19_24;
        boolean isEnum;
        AbstractSet enums;
        boolean loadBalancer;
        Object name = attribute.name();
        if (Strings.isNullOrEmpty((String)name) || "##default".equals(name)) {
            name = fieldName;
        }
        if (!(loadBalancer = "LoadBalanceDefinition".equals(originalClassType.getSimpleName())) && "inheritErrorHandler".equals(name)) {
            return true;
        }
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        name = prefix + (String)name;
        Class<?> fieldTypeElement = fieldElement.getType();
        String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
        boolean isDuration = false;
        if (metadata != null && !Strings.isNullOrEmpty((String)metadata.javaType())) {
            String jt = metadata.javaType();
            if ("java.time.Duration".equals(jt)) {
                isDuration = true;
            } else {
                fieldTypeName = jt;
            }
        }
        String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
        String docComment = this.findJavaDoc(fieldElement, fieldName, (String)name, classElement, true);
        boolean required = attribute.required();
        required = this.findRequired(fieldElement, required);
        if (metadata != null && !Strings.isNullOrEmpty((String)metadata.enums())) {
            String[] stringArray;
            enums = new LinkedHashSet();
            isEnum = true;
            for (String val : stringArray = metadata.enums().split(",")) {
                enums.add(val.trim());
            }
        } else {
            enums = new TreeSet();
            isEnum = fieldTypeElement.isEnum();
            if (isEnum) {
                for (Object val : fieldTypeElement.getEnumConstants()) {
                    String str = val.toString();
                    str = SchemaHelper.camelCaseToDash(str);
                    enums.add(str);
                }
            }
        }
        Object var19_22 = null;
        if (metadata != null) {
            String string = metadata.displayName();
        }
        boolean bl = fieldElement.getAnnotation(Deprecated.class) != null;
        String deprecationNote = null;
        if (metadata != null) {
            deprecationNote = metadata.deprecationNote();
        }
        String label = null;
        if (metadata != null) {
            label = metadata.label();
        }
        EipModel.EipOptionModel ep = this.createOption((String)name, (String)var19_24, "attribute", fieldTypeName, required, defaultValue, label, docComment, bl, deprecationNote, isEnum, enums, null, false, isDuration);
        eipOptions.add(ep);
        return false;
    }

    private void processValue(Class<?> originalClassType, Class<?> classElement, Field fieldElement, String fieldName, Set<EipModel.EipOptionModel> eipOptions, String prefix, String modelName) {
        Object name = fieldName;
        if ("expression".equals(name) && !this.expressionRequired(modelName)) {
            return;
        }
        name = prefix + (String)name;
        String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
        String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
        String docComment = this.findJavaDoc(fieldElement, fieldName, (String)name, classElement, true);
        boolean required = true;
        required = this.findRequired(fieldElement, required);
        String displayName = null;
        boolean isDuration = false;
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty((String)metadata.javaType())) {
            String jt = metadata.javaType();
            if ("java.time.Duration".equals(jt)) {
                isDuration = true;
            } else {
                fieldTypeName = jt;
            }
        }
        if (metadata != null) {
            displayName = metadata.displayName();
        }
        boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
        String deprecationNote = null;
        if (metadata != null) {
            deprecationNote = metadata.deprecationNote();
        }
        String label = null;
        if (metadata != null) {
            label = metadata.label();
        }
        EipModel.EipOptionModel ep = this.createOption((String)name, displayName, "value", fieldTypeName, required, defaultValue, label, docComment, deprecated, deprecationNote, false, null, null, false, isDuration);
        eipOptions.add(ep);
    }

    /*
     * WARNING - void declaration
     */
    private void processElement(Class<?> originalClassType, Class<?> classElement, XmlElement element, Field fieldElement, Set<EipModel.EipOptionModel> eipOptions, String prefix) {
        String fieldName = fieldElement.getName();
        if (element != null) {
            void var19_24;
            void var20_29;
            boolean isEnum;
            boolean asPredicate;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            String name = this.fetchElementName(element, fieldElement, prefix);
            Class<?> fieldTypeElement = fieldElement.getType();
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            boolean isDuration = false;
            if (metadata != null && !Strings.isNullOrEmpty((String)metadata.javaType())) {
                String jt = metadata.javaType();
                if ("java.time.Duration".equals(jt)) {
                    isDuration = true;
                } else {
                    fieldTypeName = jt;
                }
            }
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = this.findJavaDoc(fieldElement, fieldName, name, classElement, true);
            boolean required = element.required();
            required = this.findRequired(fieldElement, required);
            boolean bl = asPredicate = fieldElement.getAnnotation(AsPredicate.class) != null;
            if (!asPredicate) {
                asPredicate = classElement.getAnnotation(AsPredicate.class) != null;
            }
            TreeSet<String> enums = new TreeSet<String>();
            if (metadata != null && !Strings.isNullOrEmpty((String)metadata.enums())) {
                String[] stringArray;
                isEnum = true;
                for (String val : stringArray = metadata.enums().split(",")) {
                    enums.add(val.trim());
                }
            } else {
                isEnum = fieldTypeElement.isEnum();
                if (isEnum) {
                    for (Object val : fieldTypeElement.getEnumConstants()) {
                        String str = val.toString();
                        str = SchemaHelper.camelCaseToDash(str);
                        enums.add(str);
                    }
                }
            }
            String string = "element";
            TreeSet treeSet = new TreeSet();
            boolean isOneOf = ONE_OF_TYPE_NAME.equals(fieldTypeName);
            if (isOneOf) {
                String string2 = "expression";
                Set<String> set = this.getOneOfs(ONE_OF_LANGUAGES);
            }
            if ("otherwise".equals(name)) {
                var20_29.add("otherwise");
            }
            String displayName = null;
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            String label = null;
            if (metadata != null) {
                label = metadata.label();
            }
            EipModel.EipOptionModel ep = this.createOption(name, displayName, (String)var19_24, fieldTypeName, required, defaultValue, label, docComment, deprecated, deprecationNote, isEnum, enums, (Set<String>)var20_29, asPredicate, isDuration);
            eipOptions.add(ep);
        }
    }

    private void processElements(Class<?> originalClassType, Class<?> classElement, XmlElements elements, Field fieldElement, Set<EipModel.EipOptionModel> eipOptions, String prefix) {
        String fieldName = fieldElement.getName();
        if (elements != null) {
            Object name = fieldName;
            name = prefix + (String)name;
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            String defaultValue = this.findDefaultValue(fieldElement, fieldTypeName);
            String docComment = this.findJavaDoc(fieldElement, fieldName, (String)name, classElement, true);
            boolean required = true;
            required = this.findRequired(fieldElement, required);
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            for (XmlElement element : elements.value()) {
                String child = element.name();
                oneOfTypes.add(child);
            }
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            String label = null;
            if (metadata != null) {
                label = metadata.label();
            }
            String kind = "element";
            EipModel.EipOptionModel ep = this.createOption((String)name, displayName, "element", fieldTypeName, required, defaultValue, label, docComment, deprecated, deprecationNote, false, null, oneOfTypes, false, false);
            eipOptions.add(ep);
        }
    }

    private void processRoute(Class<?> classElement, Set<EipModel.EipOptionModel> eipOptions) {
        String docComment = this.findJavaDoc(null, "group", null, classElement, true);
        EipModel.EipOptionModel ep = this.createOption("group", "Group", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "nodePrefixId", null, classElement, true);
        ep = this.createOption("nodePrefixId", "Node Prefix Id", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "routeConfigurationId", null, classElement, true);
        ep = this.createOption("routeConfigurationId", "Route Configuration Id", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "precondition", null, classElement, true);
        ep = this.createOption("precondition", "Precondition", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "streamCache", null, classElement, true);
        ep = this.createOption("streamCache", "Stream Cache", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "trace", null, classElement, true);
        ep = this.createOption("trace", "Trace", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "messageHistory", null, classElement, true);
        ep = this.createOption("messageHistory", "Message History", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "logMask", null, classElement, true);
        ep = this.createOption("logMask", "Log Mask", "attribute", "java.lang.String", false, "false", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "delayer", null, classElement, true);
        ep = this.createOption("delayer", "Delayer", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, true);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "autoStartup", null, classElement, true);
        ep = this.createOption("autoStartup", "Auto Startup", "attribute", "java.lang.String", false, "true", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "startupOrder", null, classElement, true);
        ep = this.createOption("startupOrder", "Startup Order", "attribute", "java.lang.Integer", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "errorHandlerRef", null, classElement, true);
        ep = this.createOption("errorHandlerRef", "Error Handler", "attribute", "java.lang.String", false, "", "error", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "routePolicyRef", null, classElement, true);
        ep = this.createOption("routePolicyRef", "Route Policy", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        LinkedHashSet<String> enums = new LinkedHashSet<String>();
        enums.add("Default");
        enums.add("Defer");
        docComment = this.findJavaDoc(null, "shutdownRoute", "Default", classElement, true);
        ep = this.createOption("shutdownRoute", "Shutdown Route", "attribute", "org.apache.camel.ShutdownRoute", false, "", "", docComment, false, null, true, enums, null, false, false);
        eipOptions.add(ep);
        enums = new LinkedHashSet();
        enums.add("CompleteCurrentTaskOnly");
        enums.add("CompleteAllTasks");
        docComment = this.findJavaDoc(null, "shutdownRunningTask", "CompleteCurrentTaskOnly", classElement, true);
        ep = this.createOption("shutdownRunningTask", "Shutdown Running Task", "attribute", "org.apache.camel.ShutdownRunningTask", false, "", "", docComment, false, null, true, enums, null, false, false);
        eipOptions.add(ep);
        TreeSet<String> oneOfTypes = new TreeSet<String>();
        oneOfTypes.add("from");
        docComment = this.findJavaDoc(null, "input", null, classElement, true);
        ep = this.createOption("input", "Input", "element", "org.apache.camel.model.FromDefinition", true, "", "", docComment, false, null, false, null, oneOfTypes, false, false);
        eipOptions.add(ep);
        oneOfTypes = new TreeSet();
        for (String superclass : ONE_OF_OUTPUTS) {
            for (ClassInfo ci : this.getIndex().getAllKnownSubclasses(DotName.createSimple((String)superclass))) {
                Class<?> child = this.loadClass(ci.name().toString());
                XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                if (rootElement == null) continue;
                String childName = rootElement.name();
                oneOfTypes.add(childName);
            }
        }
        oneOfTypes.remove("route");
        docComment = this.findJavaDoc(null, "outputs", null, classElement, true);
        ep = this.createOption("outputs", "Outputs", "element", "java.util.List<org.apache.camel.model.ProcessorDefinition<?>>", true, "", "", docComment, false, null, false, null, oneOfTypes, false, false);
        eipOptions.add(ep);
    }

    private void processIdentified(Class<?> classElement, Set<EipModel.EipOptionModel> eipOptions) {
        String docComment = this.findJavaDoc(null, "id", null, classElement, true);
        EipModel.EipOptionModel ep = this.createOption("id", "Id", "attribute", "java.lang.String", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
        docComment = this.findJavaDoc(null, "description", null, classElement, true);
        ep = this.createOption("description", "Description", "element", "org.apache.camel.model.DescriptionDefinition", false, "", "", docComment, false, null, false, null, null, false, false);
        eipOptions.add(ep);
    }

    private void processRoutes(Class<?> originalClassType, Field fieldElement, String fieldName, Set<EipModel.EipOptionModel> eipOptions) {
        if ("routes".equals(fieldName)) {
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            oneOfTypes.add("route");
            EipModel.EipOptionModel ep = this.createOption("routes", "Routes", "element", fieldTypeName, false, "", "", "Contains the Camel routes", false, null, false, null, oneOfTypes, false, false);
            eipOptions.add(ep);
        }
    }

    private void processRests(Class<?> originalClassType, Field fieldElement, String fieldName, Set<EipModel.EipOptionModel> eipOptions) {
        if ("rests".equals(fieldName)) {
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            TreeSet<String> oneOfTypes = new TreeSet<String>();
            oneOfTypes.add("rest");
            EipModel.EipOptionModel ep = this.createOption("rests", "Rests", "element", fieldTypeName, false, "", "", "Contains the rest services defined using the rest-dsl", false, null, false, null, oneOfTypes, false, false);
            eipOptions.add(ep);
        }
    }

    private void processOutputs(Class<?> originalClassType, XmlElementRef elementRef, Field fieldElement, String fieldName, Set<EipModel.EipOptionModel> eipOptions, String prefix) {
        if ("outputs".equals(fieldName) && this.supportOutputs(originalClassType)) {
            String name = this.fetchName(elementRef.name(), fieldName, prefix);
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            Set<String> oneOfTypes = this.getOneOfs(ONE_OF_OUTPUTS);
            oneOfTypes.remove("route");
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            String label = null;
            if (metadata != null) {
                label = metadata.label();
            }
            String kind = "element";
            EipModel.EipOptionModel ep = this.createOption(name, displayName, kind, fieldTypeName, true, "", label, "", deprecated, deprecationNote, false, null, oneOfTypes, false, false);
            eipOptions.add(ep);
        }
    }

    private void processVerbs(Class<?> originalClassType, XmlElementRef elementRef, Field fieldElement, String fieldName, Set<EipModel.EipOptionModel> eipOptions, String prefix) {
        if ("verbs".equals(fieldName) && this.supportOutputs(originalClassType)) {
            String name = this.fetchName(elementRef.name(), fieldName, prefix);
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            String docComment = this.findJavaDoc(fieldElement, fieldName, name, originalClassType, true);
            Set<String> oneOfTypes = this.getOneOfs(ONE_OF_VERBS);
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            String label = null;
            if (metadata != null) {
                label = metadata.label();
            }
            String kind = "element";
            EipModel.EipOptionModel ep = this.createOption(name, displayName, kind, fieldTypeName, true, "", label, docComment, deprecated, deprecationNote, false, null, oneOfTypes, false, false);
            eipOptions.add(ep);
        }
    }

    private void processRefExpression(Class<?> originalClassType, Class<?> classElement, XmlElementRef elementRef, Field fieldElement, String fieldName, Set<EipModel.EipOptionModel> eipOptions, String prefix) {
        if ("expression".equals(fieldName)) {
            boolean asPredicate;
            String name = this.fetchName(elementRef.name(), fieldName, prefix);
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            String docComment = this.findJavaDoc(fieldElement, fieldName, name, originalClassType, true);
            boolean bl = asPredicate = fieldElement.getAnnotation(AsPredicate.class) != null;
            if (!asPredicate) {
                boolean bl2 = asPredicate = classElement.getAnnotation(AsPredicate.class) != null;
            }
            if (!asPredicate) {
                asPredicate = originalClassType.getAnnotation(AsPredicate.class) != null;
            }
            Set<String> oneOfTypes = this.getOneOfs(ONE_OF_LANGUAGES);
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            String label = null;
            if (metadata != null) {
                label = metadata.label();
            }
            String kind = "expression";
            boolean required = this.expressionRequired(name);
            EipModel.EipOptionModel ep = this.createOption(name, displayName, "expression", fieldTypeName, required, "", label, docComment, deprecated, deprecationNote, false, null, oneOfTypes, asPredicate, false);
            eipOptions.add(ep);
        }
    }

    private Set<String> getOneOfs(String[] classes) {
        TreeSet<String> oneOfTypes = new TreeSet<String>();
        for (String superclass : classes) {
            for (ClassInfo ci : this.getIndex().getAllKnownSubclasses(DotName.createSimple((String)superclass))) {
                Class<?> child = this.loadClass(ci.name().toString());
                XmlRootElement rootElement = child.getAnnotation(XmlRootElement.class);
                if (rootElement == null) continue;
                String childName = rootElement.name();
                oneOfTypes.add(childName);
            }
        }
        return oneOfTypes;
    }

    private void processRefWhenClauses(Class<?> originalClassType, XmlElementRef elementRef, Field fieldElement, String fieldName, Set<EipModel.EipOptionModel> eipOptions, String prefix) {
        if ("whenClauses".equals(fieldName)) {
            String name = this.fetchName(elementRef.name(), fieldName, prefix);
            String fieldTypeName = SchemaGeneratorMojo.getTypeName(GenericsUtil.resolveType(originalClassType, fieldElement));
            String docComment = this.findJavaDoc(fieldElement, fieldName, name, originalClassType, true);
            HashSet<String> oneOfTypes = new HashSet<String>();
            oneOfTypes.add("when");
            boolean asPredicate = true;
            String displayName = null;
            Metadata metadata = fieldElement.getAnnotation(Metadata.class);
            if (metadata != null) {
                displayName = metadata.displayName();
            }
            boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
            String deprecationNote = null;
            if (metadata != null) {
                deprecationNote = metadata.deprecationNote();
            }
            String label = null;
            if (metadata != null) {
                label = metadata.label();
            }
            String kind = "element";
            EipModel.EipOptionModel ep = this.createOption(name, displayName, "element", fieldTypeName, false, "", label, docComment, deprecated, deprecationNote, false, null, oneOfTypes, asPredicate, false);
            eipOptions.add(ep);
        }
    }

    private String fetchName(String elementRef, String fieldName, String prefix) {
        Object name = elementRef;
        if (Strings.isNullOrEmpty((String)name) || "##default".equals(name)) {
            name = fieldName;
        }
        name = prefix + (String)name;
        return name;
    }

    private String fetchElementName(XmlElement element, Field fieldElement, String prefix) {
        XmlElementWrapper wrapper;
        String n;
        String fieldName = fieldElement.getName();
        Object name = element.name();
        if (Strings.isNullOrEmpty((String)name) || "##default".equals(name)) {
            name = fieldName;
        }
        if ("value".equals(name) && !"##default".equals(n = (wrapper = fieldElement.getAnnotation(XmlElementWrapper.class)).name())) {
            name = n;
        }
        name = prefix + (String)name;
        return name;
    }

    private boolean supportOutputs(Class<?> classElement) {
        return this.loadClass("org.apache.camel.model.OutputNode").isAssignableFrom(classElement);
    }

    private String findDefaultValue(Field fieldElement, String fieldTypeName) {
        String defaultValue = null;
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null && !Strings.isNullOrEmpty((String)metadata.defaultValue())) {
            defaultValue = metadata.defaultValue();
        }
        if (defaultValue == null && ("boolean".equals(fieldTypeName) || "java.lang.Boolean".equals(fieldTypeName))) {
            defaultValue = "false";
        }
        return defaultValue;
    }

    private boolean expressionRequired(String modelName) {
        return !"method".equals(modelName) && !"tokenize".equals(modelName) && !"xtokenize".equals(modelName);
    }

    private boolean findRequired(Field fieldElement, boolean defaultValue) {
        Metadata metadata = fieldElement.getAnnotation(Metadata.class);
        if (metadata != null) {
            return metadata.required();
        }
        return defaultValue;
    }

    private boolean hasAbstract(Class<?> classElement) {
        for (String name : ONE_OF_ABSTRACTS) {
            if (!this.hasSuperClass(classElement, name)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInput(Class<?> classElement) {
        for (String name : ONE_OF_INPUTS) {
            if (!this.hasSuperClass(classElement, name)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutput(EipModel model) {
        switch (model.getName()) {
            case "route": 
            case "routeTemplate": 
            case "rest": {
                return true;
            }
            case "policy": 
            case "transacted": {
                return false;
            }
        }
        return model.getOptions().stream().anyMatch(option -> "outputs".equals(option.getName()));
    }

    private EipModel.EipOptionModel createOption(String name, String displayName, String kind, String type, boolean required, String defaultValue, String label, String description, boolean deprecated, String deprecationNote, boolean enumType, Set<String> enums, Set<String> oneOfs, boolean asPredicate, boolean isDuration) {
        EipModel.EipOptionModel option = new EipModel.EipOptionModel();
        option.setName(name);
        option.setDisplayName(Strings.isNullOrEmpty((String)displayName) ? Strings.asTitle((String)name) : displayName);
        option.setKind(kind);
        option.setRequired(required);
        option.setDefaultValue("java.lang.Boolean".equals(type) && !Strings.isNullOrEmpty((String)defaultValue) ? Boolean.valueOf(Boolean.parseBoolean(defaultValue)) : defaultValue);
        if (!Strings.isNullOrEmpty((String)label)) {
            option.setLabel(label);
        }
        option.setDescription(JavadocHelper.sanitizeDescription((String)description, (boolean)false));
        option.setDeprecated(deprecated);
        option.setDeprecationNote(Strings.isNullOrEmpty((String)deprecationNote) ? null : deprecationNote);
        option.setType(SchemaGeneratorMojo.getType(type, enumType, isDuration));
        option.setJavaType(type);
        option.setEnums(enums != null && !enums.isEmpty() ? new ArrayList<String>(enums) : null);
        option.setOneOfs(oneOfs != null && !oneOfs.isEmpty() ? new ArrayList<String>(oneOfs) : null);
        option.setAsPredicate(asPredicate);
        return option;
    }

    private boolean hasSuperClass(Class<?> classElement, String superClassName) {
        return this.loadClass(superClassName).isAssignableFrom(classElement);
    }

    private String findJavaDoc(Field fieldElement, String fieldName, String name, Class<?> classElement, boolean builderPattern) {
        String doc;
        String doc2;
        Metadata md;
        if (fieldElement != null && (md = fieldElement.getAnnotation(Metadata.class)) != null && !Strings.isNullOrEmpty((String)(doc2 = md.description()))) {
            return doc2;
        }
        JavaClassSource source = this.javaClassSource(classElement.getName());
        FieldSource field = source.getField(fieldName);
        if (field != null && !Strings.isNullOrEmpty((String)(doc = field.getJavaDoc().getFullText()))) {
            return doc;
        }
        Object setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        if ("setMdcLoggingKeysPattern".equals(setterName)) {
            setterName = "setMDCLoggingKeysPattern";
        }
        for (Object setter : source.getMethods()) {
            String doc3;
            if (setter.getParameters().size() != 1 || !setter.getName().equals(setterName) || Strings.isNullOrEmpty((String)(doc3 = setter.getJavaDoc().getFullText()))) continue;
            return doc3;
        }
        String getterName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        for (MethodSource setter : source.getMethods()) {
            String doc4;
            if (!setter.getParameters().isEmpty() || !setter.getName().equals(getterName) || Strings.isNullOrEmpty((String)(doc4 = setter.getJavaDoc().getFullText()))) continue;
            return doc4;
        }
        if (builderPattern) {
            String doc5;
            if (name != null && !name.equals(fieldName) && (doc5 = this.getDoc(source, name)) != null) {
                return doc5;
            }
            doc5 = this.getDoc(source, fieldName);
            if (doc5 != null) {
                return doc5;
            }
        }
        return "";
    }

    private String getDoc(JavaClassSource source, String name) {
        String doc;
        for (MethodSource builder : source.getMethods()) {
            if (builder.getParameters().size() != 1 || !builder.getName().equals(name) || Strings.isNullOrEmpty((String)(doc = builder.getJavaDoc().getFullText()))) continue;
            return doc;
        }
        for (MethodSource builder : source.getMethods()) {
            if (!builder.getParameters().isEmpty() || !builder.getName().equals(name) || Strings.isNullOrEmpty((String)(doc = builder.getJavaDoc().getFullText()))) continue;
            return doc;
        }
        return null;
    }

    private String getDocComment(Class<?> classElement) {
        JavaClassSource source = this.javaClassSource(classElement.getName());
        return source.getJavaDoc().getFullText();
    }

    private JavaClassSource javaClassSource(String className) {
        return this.sources.computeIfAbsent(className, this::doParseJavaClassSource);
    }

    private JavaClassSource doParseJavaClassSource(String className) {
        try {
            Path srcDir = this.project.getBasedir().toPath().resolve("src/main/java");
            Path file = srcDir.resolve(className.replace('.', '/') + ".java");
            String fileContent = new String(Files.readAllBytes(file));
            return (JavaClassSource)Roaster.parse((String)fileContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse java class " + className, e);
        }
    }

    private static String getTypeName(Type fieldType) {
        String fieldTypeName = new GenericType(fieldType).toString();
        fieldTypeName = fieldTypeName.replace('$', '.');
        return fieldTypeName;
    }

    public static String getType(String type, boolean enumType, boolean isDuration) {
        if (enumType) {
            return "enum";
        }
        if (isDuration) {
            return "duration";
        }
        if (type == null) {
            return "object";
        }
        if (type.equals(URI.class.getName()) || type.equals(URL.class.getName())) {
            return "string";
        }
        if (type.equals(File.class.getName())) {
            return "string";
        }
        if (type.equals(Date.class.getName())) {
            return "string";
        }
        if (type.startsWith("java.lang.Class")) {
            return "string";
        }
        if (type.startsWith("java.util.List") || type.startsWith("java.util.Collection")) {
            return "array";
        }
        String primitive = SchemaGeneratorMojo.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name) || "char".equals(name)) {
            return "string";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name) || "boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name) || "int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name) || "long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name) || "short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name) || "byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name) || "float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name) || "double".equals(name)) {
            return "number";
        }
        return null;
    }

    private static final class EipOptionComparator
    implements Comparator<EipModel.EipOptionModel> {
        private final EipModel model;
        private final boolean restVerb;

        private EipOptionComparator(EipModel model) {
            this.model = model;
            this.restVerb = this.isRestVerb(model);
        }

        @Override
        public int compare(EipModel.EipOptionModel o1, EipModel.EipOptionModel o2) {
            int weight2;
            int weight;
            if (this.restVerb) {
                weight = this.weightRestVerb(o1);
                weight2 = this.weightRestVerb(o2);
            } else {
                weight = this.weight(o1);
                weight2 = this.weight(o2);
            }
            if (weight == weight2) {
                return 1;
            }
            return weight2 - weight;
        }

        private boolean isRestVerb(EipModel model) {
            if ("rest".equals(model.getLabel())) {
                String name = model.getName();
                return "delete".equals(name) || "get".equals(name) || "head".equals(name) || "patch".equals(name) || "post".equals(name) || "put".equals(name);
            }
            return false;
        }

        private int weightRestVerb(EipModel.EipOptionModel o) {
            String name = o.getName();
            if ("path".equals(name)) {
                return 20;
            }
            if ("to".equals(name)) {
                return 19;
            }
            return this.weight(o);
        }

        private int weight(EipModel.EipOptionModel o) {
            String name = o.getName();
            if (o.isRequired() && ("language".equals(name) || "name".equals(name) || "key".equals(name))) {
                return 20;
            }
            if ("expression".equals(name)) {
                return 10;
            }
            if ("description".equals(name)) {
                return -10;
            }
            if ("id".equals(name)) {
                return -9;
            }
            if ("pattern".equals(name) && "to".equals(this.model.getName())) {
                return -8;
            }
            return 0;
        }
    }
}

