/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerEndpoint;
import org.apache.camel.component.optaplanner.OptaplannerSolutionEvent;
import org.apache.camel.component.optaplanner.OptaplannerSolutionEventListener;
import org.apache.camel.support.DefaultConsumer;

public class OptaPlannerConsumer
extends DefaultConsumer {
    private final OptaPlannerEndpoint endpoint;
    private final OptaPlannerConfiguration configuration;
    private OptaplannerSolutionEventListener solverJobListener;

    public OptaPlannerConsumer(OptaPlannerEndpoint endpoint, Processor processor, OptaPlannerConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.solverJobListener = this::processSolverJobEvent;
    }

    public void processSolverJobEvent(OptaplannerSolutionEvent event) {
        Exchange exchange = this.createExchange(true);
        exchange.getMessage().setHeader("CamelOptaPlannerBestSolution", event.getBestSolution());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException((Throwable)exchange.getException());
        }
    }

    protected void doStart() throws Exception {
        Long problemId = this.configuration.getProblemId();
        this.endpoint.addSolutionEventListener(problemId, this.solverJobListener);
        super.doStart();
    }

    protected void doStop() throws Exception {
        Long problemId = this.configuration.getProblemId();
        this.endpoint.removeSolutionEventListener(problemId, this.solverJobListener);
        super.doStop();
    }
}

