/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerConstants;
import org.apache.camel.component.optaplanner.OptaPlannerConsumer;
import org.apache.camel.component.optaplanner.OptaPlannerProducer;
import org.apache.camel.component.optaplanner.OptaplannerSolutionEventListener;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;

@UriEndpoint(firstVersion="2.13.0", scheme="optaplanner", title="OptaPlanner", syntax="optaplanner:problemName", category={Category.WORKFLOW}, headersClass=OptaPlannerConstants.class)
public class OptaPlannerEndpoint
extends DefaultEndpoint {
    private static final Map<String, Solver<Object>> SOLVERS = new ConcurrentHashMap<String, Solver<Object>>();
    private static final Map<Long, Set<OptaplannerSolutionEventListener>> SOLUTION_LISTENER = new ConcurrentHashMap<Long, Set<OptaplannerSolutionEventListener>>();
    @UriParam
    private OptaPlannerConfiguration configuration;

    public OptaPlannerEndpoint(String uri, Component component, OptaPlannerConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public OptaPlannerConfiguration getConfiguration() {
        return this.configuration;
    }

    protected Solver<Object> getOrCreateSolver(String solverId) {
        return SOLVERS.computeIfAbsent(solverId, k -> this.createSolver());
    }

    protected Solver<Object> createSolver() {
        ClassLoader classLoader = this.getCamelContext().getApplicationContextClassLoader();
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)this.configuration.getConfigFile(), (ClassLoader)classLoader);
        return solverFactory.buildSolver();
    }

    protected Solver<Object> getSolver(String solverId) {
        return SOLVERS.get(solverId);
    }

    public Producer createProducer() {
        return new OptaPlannerProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        OptaPlannerConsumer consumer = new OptaPlannerConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStop() throws Exception {
        for (Map.Entry<String, Solver<Object>> solver : SOLVERS.entrySet()) {
            solver.getValue().terminateEarly();
            SOLVERS.remove(solver.getKey());
        }
        super.doStop();
    }

    protected Set<OptaplannerSolutionEventListener> getSolutionEventListeners(Long problemId) {
        return SOLUTION_LISTENER.get(problemId);
    }

    protected void addSolutionEventListener(Long problemId, OptaplannerSolutionEventListener listener) {
        SOLUTION_LISTENER.computeIfAbsent(problemId, k -> new HashSet()).add(listener);
    }

    protected void removeSolutionEventListener(Long problemId, OptaplannerSolutionEventListener listener) {
        SOLUTION_LISTENER.computeIfPresent(problemId, (k, listeners) -> {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                return null;
            }
            return listeners;
        });
    }
}

