/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry2;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.opentelemetry2.OpenTelemetrySpanAdapter;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.SpanContextPropagationExtractor;
import org.apache.camel.telemetry.SpanContextPropagationInjector;
import org.apache.camel.telemetry.SpanLifecycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="opentelemetry-tracer-2")
@Configurer
@ManagedResource(description="OpenTelemetry2")
public class OpenTelemetryTracer
extends org.apache.camel.telemetry.Tracer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryTracer.class);
    private Tracer tracer;
    private ContextPropagators contextPropagators;

    protected void initTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), Tracer.class);
        }
        if (this.tracer == null) {
            this.tracer = GlobalOpenTelemetry.get().getTracer("camel");
        }
        if (this.tracer == null) {
            throw new RuntimeCamelException("Could not find any Opentelemetry tracer!");
        }
        if (this.contextPropagators == null) {
            this.contextPropagators = (ContextPropagators)CamelContextHelper.findSingleByType((CamelContext)this.getCamelContext(), ContextPropagators.class);
        }
        if (this.contextPropagators == null) {
            this.contextPropagators = GlobalOpenTelemetry.get().getPropagators();
        }
        if (this.contextPropagators == null) {
            throw new RuntimeCamelException("Could not find any Opentelemetry context propagator!");
        }
        this.setSpanLifecycleManager(new OpentelemetrySpanLifecycleManager(this.tracer, this.contextPropagators));
    }

    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    void setContextPropagators(ContextPropagators cp) {
        this.contextPropagators = cp;
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("Opentelemetry2 enabled");
    }

    private class OpentelemetrySpanLifecycleManager
    implements SpanLifecycleManager {
        private final Tracer tracer;
        private final ContextPropagators contextPropagators;

        private OpentelemetrySpanLifecycleManager(Tracer tracer, ContextPropagators contextPropagators) {
            this.tracer = tracer;
            this.contextPropagators = contextPropagators;
        }

        public Span create(String spanName, Span parent, SpanContextPropagationExtractor extractor) {
            SpanBuilder builder = this.tracer.spanBuilder(spanName);
            Baggage baggage = null;
            if (parent != null) {
                OpenTelemetrySpanAdapter otelParentSpan = (OpenTelemetrySpanAdapter)parent;
                builder = builder.setParent(Context.current().with((ImplicitContextKeyed)otelParentSpan.getSpan()));
                baggage = otelParentSpan.getBaggage();
            } else {
                Context current = null;
                if (extractor.get("traceparent") != null) {
                    current = Context.current();
                }
                Context ctx = this.contextPropagators.getTextMapPropagator().extract(current, (Object)extractor, (TextMapGetter)new TextMapGetter<SpanContextPropagationExtractor>(){

                    public Iterable<String> keys(SpanContextPropagationExtractor carrier) {
                        return carrier.keys();
                    }

                    public String get(SpanContextPropagationExtractor carrier, String key) {
                        if (carrier.get(key) == null) {
                            return null;
                        }
                        return carrier.get(key).toString();
                    }
                });
                builder = builder.setParent(ctx);
            }
            return new OpenTelemetrySpanAdapter(builder.startSpan(), baggage);
        }

        public void activate(Span span) {
            OpenTelemetrySpanAdapter otelSpan = (OpenTelemetrySpanAdapter)span;
            otelSpan.makeCurrent();
        }

        public void deactivate(Span span) {
            OpenTelemetrySpanAdapter otelSpan = (OpenTelemetrySpanAdapter)span;
            otelSpan.end();
        }

        public void close(Span span) {
            OpenTelemetrySpanAdapter otelSpan = (OpenTelemetrySpanAdapter)span;
            otelSpan.close();
        }

        public void inject(Span span, SpanContextPropagationInjector injector, boolean includeTracing) {
            OpenTelemetrySpanAdapter otelSpan = (OpenTelemetrySpanAdapter)span;
            Context ctx = Context.current().with((ImplicitContextKeyed)otelSpan.getSpan());
            if (otelSpan.getBaggage() != null) {
                ctx = ctx.with((ImplicitContextKeyed)otelSpan.getBaggage());
            }
            this.contextPropagators.getTextMapPropagator().inject(ctx, (Object)injector, (carrier, key, value) -> carrier.put(key, value));
            if (includeTracing) {
                injector.put("CAMEL_TRACE_ID", otelSpan.getSpan().getSpanContext().getTraceId());
                injector.put("CAMEL_SPAN_ID", otelSpan.getSpan().getSpanContext().getSpanId());
            }
        }
    }
}

