/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.neutron.NeutronEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.SubnetBuilder;
import org.openstack4j.openstack.networking.domain.NeutronPool;

public class SubnetProducer
extends AbstractOpenstackProducer {
    public SubnetProducer(NeutronEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Subnet in = this.messageToSubnet(exchange.getIn());
        Subnet out = this.os.networking().subnet().create(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("subnetId", String.class), String.class);
        StringHelper.notEmpty((String)id, (String)"Subnet ID");
        Subnet out = this.os.networking().subnet().get(id);
        exchange.getIn().setBody((Object)out);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.os.networking().subnet().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", msg.getHeader("subnetId", String.class), String.class);
        StringHelper.notEmpty((String)id, (String)"Subnet ID");
        ActionResponse response = this.os.networking().subnet().delete(id);
        this.checkFailure(response, exchange, "Delete network " + id);
    }

    private Subnet messageToSubnet(Message message) {
        Subnet subnet = (Subnet)message.getBody(Subnet.class);
        if (subnet == null) {
            Map headers = message.getHeaders();
            SubnetBuilder builder = Builders.subnet();
            StringHelper.notEmpty((String)((String)message.getHeader("name", String.class)), (String)"Name");
            builder.name((String)message.getHeader("name", String.class));
            StringHelper.notEmpty((String)((String)message.getHeader("networkId", String.class)), (String)"Network ID");
            builder.networkId((String)message.getHeader("networkId", String.class));
            ObjectHelper.notNull((Object)((IPVersionType)message.getHeader("ipVersion", IPVersionType.class)), (String)"IP version");
            builder.ipVersion((IPVersionType)message.getHeader("ipVersion", IPVersionType.class));
            if (headers.containsKey("cidr")) {
                builder.cidr((String)message.getHeader("cidr", String.class));
            }
            if (headers.containsKey("subnetPools")) {
                NeutronPool pool = (NeutronPool)message.getHeader("subnetPools", NeutronPool.class);
                builder.addPool(pool.getStart(), pool.getEnd());
            }
            if (headers.containsKey("networkId")) {
                builder.networkId((String)message.getHeader("networkId", String.class));
            }
            if (headers.containsKey("enableDHCP")) {
                builder.enableDHCP(((Boolean)message.getHeader("enableDHCP", Boolean.class)).booleanValue());
            }
            if (headers.containsKey("gateway")) {
                builder.gateway((String)message.getHeader("gateway", String.class));
            }
            subnet = (Subnet)builder.build();
        }
        return subnet;
    }
}

