/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.opensearch.aggregation;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;

@Metadata(label="bean", description="Aggregates two OpenSearch BulkOperation into a single BulkRequest", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class OpensearchBulkRequestAggregationStrategy
implements AggregationStrategy {
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Object objBody = newExchange.getIn().getBody();
        if (!(objBody instanceof BulkOperation[])) {
            throw new InvalidPayloadRuntimeException(newExchange, BulkOperation[].class);
        }
        BulkOperation[] newBody = (BulkOperation[])objBody;
        BulkRequest.Builder builder = new BulkRequest.Builder();
        builder.operations(List.of(newBody));
        if (ObjectHelper.isNotEmpty((Object)oldExchange)) {
            BulkRequest request = (BulkRequest)oldExchange.getIn().getBody(BulkRequest.class);
            builder.operations(request.operations());
        }
        newExchange.getIn().setBody((Object)builder.build());
        return oldExchange;
    }
}

