/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.core.util.Yaml31;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.DefaultRestDefinitionsResolver;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestApiResponseAdapter;
import org.apache.camel.openapi.RestDefinitionsResolver;
import org.apache.camel.openapi.RestOpenApiReader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiSupport {
    public static DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    static final String HEADER_X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    static final String HEADER_HOST = "Host";
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiSupport.class);
    private final RestOpenApiReader reader = new RestOpenApiReader();
    private final RestDefinitionsResolver localRestDefinitionResolver = new DefaultRestDefinitionsResolver();
    private volatile RestDefinitionsResolver jmxRestDefinitionResolver;
    private boolean cors;

    private static void setupCorsHeaders(RestApiResponseAdapter response, Map<String, String> corsHeaders) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        String string = allowOrigin = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = corsHeaders != null ? corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using CORS headers[");
            LOG.trace("  Access-Control-Allow-Origin={}", (Object)allowOrigin);
            LOG.trace("  Access-Control-Allow-Methods={}", (Object)allowMethods);
            LOG.trace("  Access-Control-Allow-Headers={}", (Object)allowHeaders);
            LOG.trace("  Access-Control-Max-Age={}", (Object)maxAge);
            LOG.trace("]");
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
    }

    static void setupXForwardedHeaders(OpenAPI openApi, Map<String, Object> headers) {
        String forwardedHost;
        String basePath = RestOpenApiSupport.getBasePathFromOasDocument(openApi);
        String host = (String)headers.get(HEADER_HOST);
        String forwardedPrefix = (String)headers.get(HEADER_X_FORWARDED_PREFIX);
        if (ObjectHelper.isNotEmpty((String)forwardedPrefix)) {
            basePath = URISupport.joinPaths((String[])new String[]{forwardedPrefix, basePath});
        }
        if (ObjectHelper.isNotEmpty((String)(forwardedHost = (String)headers.get(HEADER_X_FORWARDED_HOST)))) {
            host = forwardedHost;
        }
        String proto = (String)headers.get(HEADER_X_FORWARDED_PROTO);
        if (openApi.getServers() != null) {
            openApi.getServers().clear();
        }
        if (ObjectHelper.isNotEmpty((String)proto)) {
            String[] schemes;
            for (String schema : schemes = proto.split(",")) {
                String trimmedScheme = schema.trim();
                String serverUrl = String.format("%s://%s%s", trimmedScheme.toLowerCase(), host, basePath);
                openApi.addServersItem(new Server().url(serverUrl));
            }
        } else {
            openApi.addServersItem(new Server().url(basePath));
        }
    }

    public static String getHostFromOasDocument(OpenAPI openapi) {
        String host = null;
        if (openapi.getServers() != null && openapi.getServers().get(0) != null) {
            try {
                URL serverUrl = new URL(RestOpenApiSupport.parseVariables(((Server)openapi.getServers().get(0)).getUrl(), (Server)openapi.getServers().get(0)));
                host = serverUrl.getHost();
            }
            catch (MalformedURLException e) {
                LOG.debug("Error when parsing OpenApi 3.0 doc server url. This exception is ignored.", (Throwable)e);
            }
        }
        return host;
    }

    public static String getBasePathFromOasDocument(OpenAPI openapi) {
        String basePath = null;
        if (openapi.getServers() != null && openapi.getServers().get(0) != null) {
            try {
                URL serverUrl;
                Server server = (Server)openapi.getServers().get(0);
                if (server.getVariables() != null && server.getVariables().get((Object)"basePath") != null) {
                    basePath = ((ServerVariable)server.getVariables().get((Object)"basePath")).getDefault();
                }
                if (basePath == null && "/".equals(basePath = (serverUrl = new URL(RestOpenApiSupport.parseVariables(((Server)openapi.getServers().get(0)).getUrl(), (Server)openapi.getServers().get(0)))).getPath().replace("//", "/"))) {
                    basePath = "";
                }
            }
            catch (MalformedURLException e) {
                basePath = ((Server)openapi.getServers().get(0)).getUrl();
            }
        }
        return basePath;
    }

    public static String parseVariables(String url, Server server) {
        Pattern p = Pattern.compile("\\{(.*?)}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String variable = m.group(1);
            if (server == null || server.getVariables() == null || server.getVariables().get((Object)variable) == null) continue;
            String varValue = ((ServerVariable)server.getVariables().get((Object)variable)).getDefault();
            url = url.replace("{" + variable + "}", varValue);
        }
        return url;
    }

    public void initOpenApi(BeanConfig openApiConfig, Map<String, Object> config) {
        String defaultProduces;
        String s = (String)config.get("openapi.version");
        if (s != null) {
            openApiConfig.setVersion(s);
        }
        if ((s = (String)config.get("base.path")) != null) {
            openApiConfig.setBasePath(s);
        }
        if ((s = (String)config.get("host")) != null) {
            openApiConfig.setHost(s);
        }
        if ((s = (String)config.get("cors")) != null) {
            this.cors = "true".equalsIgnoreCase(s);
        }
        if ((s = (String)config.get("schemes")) == null) {
            s = (String)config.get("schemas");
        }
        if (s != null) {
            String[] schemes = s.split(",");
            openApiConfig.setSchemes(schemes);
        } else {
            openApiConfig.setSchemes(new String[]{"http"});
        }
        String defaultConsumes = (String)config.get("api.default.consumes");
        if (defaultConsumes != null) {
            openApiConfig.setDefaultConsumes(defaultConsumes);
        }
        if ((defaultProduces = (String)config.get("api.default.produces")) != null) {
            openApiConfig.setDefaultProduces(defaultProduces);
        }
        String version = (String)config.get("api.version");
        String title = (String)config.get("api.title");
        String description = (String)config.get("api.description");
        String termsOfService = (String)config.get("api.termsOfService");
        String licenseName = (String)config.get("api.license.name");
        String licenseUrl = (String)config.get("api.license.url");
        String contactName = (String)config.get("api.contact.name");
        String contactUrl = (String)config.get("api.contact.url");
        String contactEmail = (String)config.get("api.contact.email");
        this.setInfo(openApiConfig, version, title, description, termsOfService, licenseName, licenseUrl, contactName, contactUrl, contactEmail);
    }

    private void setInfo(BeanConfig openApiConfig, String version, String title, String description, String termsOfService, String licenseName, String licenseUrl, String contactName, String contactUrl, String contactEmail) {
        Info info = new Info().version(version).title(title).description(description).termsOfService(termsOfService);
        if (licenseName != null || licenseUrl != null) {
            License license = new License().name(licenseName).url(licenseUrl);
            info.setLicense(license);
        }
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = new Contact().name(contactName).url(contactUrl).email(contactEmail);
            info.setContact(contact);
        }
        openApiConfig.setInfo(info);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext) throws Exception {
        return this.localRestDefinitionResolver.getRestDefinitions(camelContext, null);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext, String camelId) throws Exception {
        if (this.jmxRestDefinitionResolver == null) {
            this.jmxRestDefinitionResolver = this.createJmxRestDefinitionsResolver(camelContext);
        }
        return this.jmxRestDefinitionResolver.getRestDefinitions(camelContext, camelId);
    }

    protected RestDefinitionsResolver createJmxRestDefinitionsResolver(CamelContext camelContext) {
        return (RestDefinitionsResolver)ResolverHelper.resolveService((CamelContext)camelContext, (FactoryFinder)camelContext.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"jmx-rest-definition-resolver", RestDefinitionsResolver.class).orElseThrow(() -> new IllegalArgumentException("Cannot find camel-openapi-java on classpath."));
    }

    public void setupXForwardHeaders(RestApiResponseAdapter response, Exchange exchange) {
        RestOpenApiSupport.setupXForwardedHeaders(response.getOpenApi(), exchange.getMessage().getHeaders());
    }

    public void renderResourceListing(CamelContext camelContext, RestApiResponseAdapter response, BeanConfig openApiConfig, boolean json, ClassResolver classResolver, RestConfiguration configuration) throws Exception {
        List<RestDefinition> rests;
        LOG.trace("renderResourceListing");
        if (this.cors) {
            RestOpenApiSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        if ((rests = this.getRestDefinitions(camelContext)) != null) {
            Map apiProperties = configuration.getApiProperties() != null ? configuration.getApiProperties() : new HashMap();
            String key = json ? "api.specification.contentType.json" : "api.specification.contentType.yaml";
            String defaultValue = json ? "application/json" : "text/yaml";
            response.setHeader("Content-Type", apiProperties.getOrDefault(key, defaultValue));
            OpenAPI openApi = response.getOpenApi();
            if (openApi == null) {
                openApi = this.reader.read(camelContext, rests, openApiConfig, camelContext.getName(), classResolver);
                if (!configuration.isApiVendorExtension()) {
                    OpenApiHelper.clearVendorExtensions(openApi);
                }
            }
            response.setOpenApi(openApi);
            byte[] bytes = RestOpenApiSupport.getFromOpenAPI(openApi, openApiConfig, byte[].class, json);
            int len = bytes.length;
            response.setHeader("Content-Length", Integer.toString(len));
            response.writeBytes(bytes);
        } else {
            response.noContent();
        }
    }

    public static String getJsonFromOpenAPIAsString(OpenAPI openApi, BeanConfig config) {
        return RestOpenApiSupport.getFromOpenAPI(openApi, config, String.class, true);
    }

    public static <T> T getFromOpenAPI(OpenAPI openApi, BeanConfig config, Class<T> type, boolean json) {
        if (config.isOpenApi2()) {
            throw new IllegalArgumentException("OpenAPI 2.x is not supported");
        }
        ObjectMapper mapper = json ? (config.isOpenApi31() ? Json31.mapper() : Json.mapper()) : (config.isOpenApi31() ? Yaml31.mapper() : Yaml.mapper());
        String result = RestOpenApiSupport.getFromOpenAPI3(openApi, mapper);
        if (type.equals(byte[].class)) {
            if (result != null) {
                return type.cast(result.getBytes(StandardCharsets.UTF_8));
            }
            return type.cast(new byte[0]);
        }
        return type.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFromOpenAPI3(OpenAPI openAPI3, ObjectMapper mapper) {
        DateFormat origin = mapper.getDateFormat();
        try {
            mapper.setDateFormat(DEFAULT_DATE_FORMAT);
            String string = mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)openAPI3);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            mapper.setDateFormat(origin);
        }
    }
}

