/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.DefaultRestDefinitionsResolver;
import org.apache.camel.openapi.OpenAPI3to2;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestApiResponseAdapter;
import org.apache.camel.openapi.RestDefinitionsResolver;
import org.apache.camel.openapi.RestOpenApiReader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiSupport {
    static final String HEADER_X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    static final String HEADER_HOST = "Host";
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiSupport.class);
    private final RestOpenApiReader reader = new RestOpenApiReader();
    private final RestDefinitionsResolver localRestDefinitionResolver = new DefaultRestDefinitionsResolver();
    private volatile RestDefinitionsResolver jmxRestDefinitionResolver;
    private boolean cors;

    private static void setupCorsHeaders(RestApiResponseAdapter response, Map<String, String> corsHeaders) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        String string = allowOrigin = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = corsHeaders != null ? corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using CORS headers[");
            LOG.trace("  Access-Control-Allow-Origin={}", (Object)allowOrigin);
            LOG.trace("  Access-Control-Allow-Methods={}", (Object)allowMethods);
            LOG.trace("  Access-Control-Allow-Headers={}", (Object)allowHeaders);
            LOG.trace("  Access-Control-Max-Age={}", (Object)maxAge);
            LOG.trace("]");
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
    }

    static void setupXForwardedHeaders(OpenAPI openApi, Map<String, Object> headers) {
        String forwardedHost;
        String basePath = RestOpenApiSupport.getBasePathFromOasDocument(openApi);
        String host = (String)headers.get(HEADER_HOST);
        String forwardedPrefix = (String)headers.get(HEADER_X_FORWARDED_PREFIX);
        if (ObjectHelper.isNotEmpty((String)forwardedPrefix)) {
            basePath = URISupport.joinPaths((String[])new String[]{forwardedPrefix, basePath});
        }
        if (ObjectHelper.isNotEmpty((String)(forwardedHost = (String)headers.get(HEADER_X_FORWARDED_HOST)))) {
            host = forwardedHost;
        }
        String proto = (String)headers.get(HEADER_X_FORWARDED_PROTO);
        if (openApi.getServers() != null) {
            openApi.getServers().clear();
        }
        if (ObjectHelper.isNotEmpty((String)proto)) {
            String[] schemes;
            for (String schema : schemes = proto.split(",")) {
                String trimmedScheme = schema.trim();
                String serverUrl = String.format("%s://%s%s", trimmedScheme.toLowerCase(), host, basePath);
                openApi.addServersItem(new Server().url(serverUrl));
            }
        } else {
            openApi.addServersItem(new Server().url(basePath));
        }
    }

    public static String getHostFromOasDocument(OpenAPI openapi) {
        String host = null;
        if (openapi.getServers() != null && openapi.getServers().get(0) != null) {
            try {
                URL serverUrl = new URL(RestOpenApiSupport.parseVariables(((Server)openapi.getServers().get(0)).getUrl(), (Server)openapi.getServers().get(0)));
                host = serverUrl.getHost();
            }
            catch (MalformedURLException e) {
                LOG.info("error when parsing OpenApi 3.0 doc server url", (Throwable)e);
            }
        }
        return host;
    }

    public static String getBasePathFromOasDocument(OpenAPI openapi) {
        String basePath = null;
        if (openapi.getServers() != null && openapi.getServers().get(0) != null) {
            try {
                URL serverUrl;
                Server server = (Server)openapi.getServers().get(0);
                if (server.getVariables() != null && server.getVariables().get((Object)"basePath") != null) {
                    basePath = ((ServerVariable)server.getVariables().get((Object)"basePath")).getDefault();
                }
                if (basePath == null && "/".equals(basePath = (serverUrl = new URL(RestOpenApiSupport.parseVariables(((Server)openapi.getServers().get(0)).getUrl(), (Server)openapi.getServers().get(0)))).getPath().replace("//", "/"))) {
                    basePath = "";
                }
            }
            catch (MalformedURLException e) {
                basePath = ((Server)openapi.getServers().get(0)).getUrl();
            }
        }
        return basePath;
    }

    public static String parseVariables(String url, Server server) {
        Pattern p = Pattern.compile("\\{(.*?)}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String var = m.group(1);
            if (server == null || server.getVariables() == null || server.getVariables().get((Object)var) == null) continue;
            String varValue = ((ServerVariable)server.getVariables().get((Object)var)).getDefault();
            url = url.replace("{" + var + "}", varValue);
        }
        return url;
    }

    public void initOpenApi(BeanConfig openApiConfig, Map<String, Object> config) {
        String defaultProduces;
        String s = (String)config.get("openapi.version");
        if (s != null) {
            openApiConfig.setVersion(s);
        }
        if ((s = (String)config.get("base.path")) != null) {
            openApiConfig.setBasePath(s);
        }
        if ((s = (String)config.get("host")) != null) {
            openApiConfig.setHost(s);
        }
        if ((s = (String)config.get("cors")) != null) {
            this.cors = "true".equalsIgnoreCase(s);
        }
        if ((s = (String)config.get("schemes")) == null) {
            s = (String)config.get("schemas");
        }
        if (s != null) {
            String[] schemes = s.split(",");
            openApiConfig.setSchemes(schemes);
        } else {
            openApiConfig.setSchemes(new String[]{"http"});
        }
        String defaultConsumes = (String)config.get("api.default.consumes");
        if (defaultConsumes != null) {
            openApiConfig.setDefaultConsumes(defaultConsumes);
        }
        if ((defaultProduces = (String)config.get("api.default.produces")) != null) {
            openApiConfig.setDefaultProduces(defaultProduces);
        }
        String version = (String)config.get("api.version");
        String title = (String)config.get("api.title");
        String description = (String)config.get("api.description");
        String termsOfService = (String)config.get("api.termsOfService");
        String licenseName = (String)config.get("api.license.name");
        String licenseUrl = (String)config.get("api.license.url");
        String contactName = (String)config.get("api.contact.name");
        String contactUrl = (String)config.get("api.contact.url");
        String contactEmail = (String)config.get("api.contact.email");
        this.setInfo(openApiConfig, version, title, description, termsOfService, licenseName, licenseUrl, contactName, contactUrl, contactEmail);
    }

    private void setInfo(BeanConfig openApiConfig, String version, String title, String description, String termsOfService, String licenseName, String licenseUrl, String contactName, String contactUrl, String contactEmail) {
        Info info = new Info().version(version).title(title).description(description).termsOfService(termsOfService);
        if (licenseName != null || licenseUrl != null) {
            License license = new License().name(licenseName).url(licenseUrl);
            info.setLicense(license);
        }
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = new Contact().name(contactName).url(contactUrl).email(contactEmail);
            info.setContact(contact);
        }
        openApiConfig.setInfo(info);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext) throws Exception {
        return this.localRestDefinitionResolver.getRestDefinitions(camelContext, null);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext, String camelId) throws Exception {
        if (this.jmxRestDefinitionResolver == null) {
            this.jmxRestDefinitionResolver = this.createJmxRestDefinitionsResolver(camelContext);
        }
        return this.jmxRestDefinitionResolver.getRestDefinitions(camelContext, camelId);
    }

    protected RestDefinitionsResolver createJmxRestDefinitionsResolver(CamelContext camelContext) {
        return (RestDefinitionsResolver)ResolverHelper.resolveService((CamelContext)camelContext, (FactoryFinder)camelContext.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"jmx-rest-definition-resolver", RestDefinitionsResolver.class).orElseThrow(() -> new IllegalArgumentException("Cannot find camel-openapi-java on classpath."));
    }

    public void renderResourceListing(CamelContext camelContext, RestApiResponseAdapter response, BeanConfig openApiConfig, boolean json, Map<String, Object> headers, ClassResolver classResolver, RestConfiguration configuration) throws Exception {
        List<RestDefinition> rests;
        LOG.trace("renderResourceListing");
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (this.cors) {
            RestOpenApiSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        if ((rests = this.getRestDefinitions(camelContext)) != null) {
            Map apiProperties;
            Map map = apiProperties = configuration.getApiProperties() != null ? configuration.getApiProperties() : new HashMap();
            if (json) {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.json", "application/json"));
                OpenAPI openApi = this.reader.read(camelContext, rests, openApiConfig, camelContext.getName(), classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestOpenApiSupport.setupXForwardedHeaders(openApi, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    OpenApiHelper.clearVendorExtensions(openApi);
                }
                byte[] bytes = null;
                if (!openApiConfig.isOpenApi3()) {
                    OpenAPI3to2 converter = new OpenAPI3to2();
                    converter.convertOpenAPI3to2(openApi);
                    bytes = converter.getSwaggerAsJson();
                } else {
                    String result = Json31.pretty((Object)openApi);
                    bytes = result.getBytes(StandardCharsets.UTF_8);
                }
                int len = bytes.length;
                response.setHeader("Content-Length", Integer.toString(len));
                response.writeBytes(bytes);
            } else {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.yaml", "text/yaml"));
                OpenAPI openApi = this.reader.read(camelContext, rests, openApiConfig, camelContext.getName(), classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestOpenApiSupport.setupXForwardedHeaders(openApi, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    OpenApiHelper.clearVendorExtensions(openApi);
                }
                byte[] bytes = null;
                if (!openApiConfig.isOpenApi3()) {
                    OpenAPI3to2 converter = new OpenAPI3to2();
                    converter.convertOpenAPI3to2(openApi);
                    bytes = converter.getSwaggerAsYaml();
                } else {
                    String result = Yaml.pretty((Object)openApi);
                    bytes = result.getBytes();
                }
                int len = bytes.length;
                response.setHeader("Content-Length", Integer.toString(len));
                response.writeBytes(bytes);
            }
        } else {
            response.noContent();
        }
    }

    public static String getJsonFromOpenAPI(OpenAPI openApi3, BeanConfig openApiConfig) {
        if (!openApiConfig.isOpenApi3()) {
            OpenAPI3to2 converter = new OpenAPI3to2();
            converter.convertOpenAPI3to2(openApi3);
            return new String(converter.getSwaggerAsJson());
        }
        return Json.pretty((Object)openApi3);
    }
}

