/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.jakarta.ServletOAuthFactory;
import org.apache.camel.oauth.vertx.VertxOAuthFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.CamelContextHelper;

public abstract class OAuthFactory {
    protected final CamelContext context;

    public OAuthFactory(CamelContext context) {
        this.context = context;
    }

    public static OAuthFactory lookupFactory(CamelContext ctx) {
        Registry registry = ctx.getRegistry();
        OAuthFactory factory = (OAuthFactory)registry.lookupByNameAndType(OAuthFactory.class.getName(), OAuthFactory.class);
        if (factory == null) {
            VertxPlatformHttpRouter vertxRouter = (VertxPlatformHttpRouter)CamelContextHelper.lookup((CamelContext)ctx, (String)"platform-http-router", VertxPlatformHttpRouter.class);
            if (vertxRouter != null) {
                factory = new VertxOAuthFactory(ctx);
                registry.bind(OAuthFactory.class.getName(), (Object)factory);
            } else {
                factory = new ServletOAuthFactory(ctx);
                registry.bind(OAuthFactory.class.getName(), (Object)factory);
            }
        }
        return factory;
    }

    public abstract OAuth createOAuth();

    public Optional<OAuth> findOAuth() {
        Registry registry = this.context.getRegistry();
        OAuth oauth = (OAuth)registry.lookupByNameAndType(OAuth.class.getName(), OAuth.class);
        return Optional.ofNullable(oauth);
    }
}

