/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oauth.AbstractOAuthProcessor;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthFactory;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.TokenCredentials;
import org.apache.camel.oauth.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerTokenProcessor
extends AbstractOAuthProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) {
        CamelContext context = exchange.getContext();
        Message msg = exchange.getMessage();
        this.logRequestHeaders(this.procName, msg);
        String authHeader = (String)msg.getHeader("Authorization", String.class);
        if (authHeader == null) {
            this.log.error("No Authorization header in request");
            msg.setHeader("CamelHttpResponseCode", (Object)400);
            msg.setBody((Object)"Authorization header");
            return;
        }
        String[] toks = authHeader.split(" ");
        if (toks.length != 2 || !"Bearer".equals(toks[0])) {
            this.log.error("Invalid Authorization header: {}", (Object)authHeader);
            msg.setHeader("CamelHttpResponseCode", (Object)400);
            msg.setBody((Object)"Invalid Authorization header");
            return;
        }
        OAuth oauth = this.findOAuth(context).orElseGet(() -> {
            OAuthFactory factory = OAuthFactory.lookupFactory(context);
            return factory.createOAuth();
        });
        String access_token = toks[1];
        UserProfile userProfile = oauth.authenticate(new TokenCredentials(access_token));
        OAuthSession session = oauth.getOrCreateSession(exchange);
        session.putUserProfile(userProfile);
        this.log.info("Authenticated {}", (Object)userProfile.subject());
        userProfile.logDetails();
    }
}

