/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oauth.AbstractOAuthProcessor;
import org.apache.camel.oauth.AuthCodeCredentials;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthCodeFlowCallback
extends AbstractOAuthProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) {
        CamelContext context = exchange.getContext();
        Message msg = exchange.getMessage();
        this.logRequestHeaders(this.procName, msg);
        String authCode = (String)msg.getHeader("code", String.class);
        if (authCode == null) {
            this.log.error("Authorization code is missing in the request");
            msg.setHeader("CamelHttpResponseCode", (Object)400);
            msg.setBody((Object)"Authorization code missing");
            return;
        }
        OAuth oauth = this.findOAuthOrThrow(context);
        OAuthSession session = oauth.getSession(exchange).orElseThrow();
        String redirectUri = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.redirectUri");
        UserProfile userProfile = oauth.authenticate(new AuthCodeCredentials().setRedirectUri(redirectUri).setCode(authCode));
        session.putUserProfile(userProfile);
        userProfile.logDetails("Authenticated");
        String postLoginUrl = session.removeValue("OAuthPostLoginUrl").orElse(null);
        if (postLoginUrl == null) {
            postLoginUrl = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.redirectUri");
            int lastSlashIdx = postLoginUrl.lastIndexOf(47);
            postLoginUrl = postLoginUrl.substring(0, lastSlashIdx + 1);
        }
        this.setSessionCookie(msg, session);
        this.sendRedirect(msg, postLoginUrl);
        this.log.info("{} - Done", (Object)this.procName);
    }
}

