/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.oauth.Credentials;
import org.apache.camel.oauth.InMemorySessionStore;
import org.apache.camel.oauth.OAuthCodeFlowParams;
import org.apache.camel.oauth.OAuthConfig;
import org.apache.camel.oauth.OAuthException;
import org.apache.camel.oauth.OAuthLogoutParams;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.OAuthSessionStore;
import org.apache.camel.oauth.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String CAMEL_OAUTH_BASE_URI = "camel.oauth.baseUri";
    public static final String CAMEL_OAUTH_CLIENT_ID = "camel.oauth.clientId";
    public static final String CAMEL_OAUTH_CLIENT_SECRET = "camel.oauth.clientSecret";
    public static final String CAMEL_OAUTH_LOGOUT_REDIRECT_URI = "camel.oauth.logout.redirectUri";
    public static final String CAMEL_OAUTH_REDIRECT_URI = "camel.oauth.redirectUri";
    public static final String CAMEL_OAUTH_SESSION_ID = "CamelOAuthSessionId";
    public static final String CAMEL_OAUTH_COOKIE = "camel.oauth.session";
    protected OAuthConfig config;
    protected OAuthSessionStore sessionStore = new InMemorySessionStore();

    public abstract void discoverOAuthConfig(CamelContext var1) throws OAuthException;

    public OAuthConfig getOAuthConfig() {
        return this.config;
    }

    public abstract UserProfile authenticate(Credentials var1) throws OAuthException;

    public abstract String buildLogoutRequestUrl(OAuthLogoutParams var1);

    public abstract String buildCodeFlowAuthRequestUrl(OAuthCodeFlowParams var1);

    public OAuthSessionStore getSessionStore() {
        return this.sessionStore;
    }

    public Optional<OAuthSession> getSession(Exchange exchange) {
        return this.getSessionStore().getSession(exchange);
    }

    public OAuthSession createSession(Exchange exchange) {
        return this.getSessionStore().createSession(exchange);
    }
}

