/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oauth.InMemorySession;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.OAuthSessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySessionStore
implements OAuthSessionStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, OAuthSession> sessions = new HashMap<String, OAuthSession>();

    @Override
    public Optional<OAuthSession> getSession(Exchange exchange) {
        Optional<OAuthSession> maybeSession;
        Message msg = exchange.getMessage();
        String sessionId = (String)msg.getHeader("CamelOAuthSessionId", String.class);
        if (sessionId == null) {
            Map<String, String> cookies = this.getCookies(exchange);
            if (cookies.get("camel.oauth.session") == null) {
                this.log.warn("No '{}' Cookie in HTTP request", (Object)"camel.oauth.session");
                return Optional.empty();
            }
            sessionId = cookies.get("camel.oauth.session");
        }
        if ((maybeSession = Optional.ofNullable(this.sessions.get(sessionId))).isEmpty()) {
            this.log.warn("No OAuthSession for: {}", (Object)sessionId);
        }
        return maybeSession;
    }

    @Override
    public OAuthSession createSession(Exchange exchange) {
        String sessionId = UUID.randomUUID().toString();
        InMemorySession session = new InMemorySession(sessionId);
        this.sessions.put(sessionId, session);
        Message msg = exchange.getMessage();
        this.log.info("New OAuthSession: {}", (Object)sessionId);
        msg.setHeader("CamelOAuthSessionId", (Object)sessionId);
        return session;
    }

    private Map<String, String> getCookies(Exchange exchange) {
        Message msg = exchange.getMessage();
        Optional<Object> maybeCookie = Optional.ofNullable(msg.getHeader("Cookie"));
        if (maybeCookie.isEmpty()) {
            this.log.warn("No Cookie in HTTP request");
            return Map.of();
        }
        String value = maybeCookie.get().toString();
        Map<String, String> cookieMap = Arrays.stream(value.split(";")).map(String::trim).map(s -> s.split("=", 2)).collect(Collectors.toMap(arr -> arr[0], arr -> ((String[])arr).length > 1 ? arr[1] : ""));
        return cookieMap;
    }
}

