/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite.operation.common;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.nitrite.AbstractNitriteOperation;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.CommonOperation;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.tool.ExportOptions;
import org.dizitart.no2.tool.Exporter;

public class ExportDatabaseOperation
extends AbstractNitriteOperation
implements CommonOperation {
    private ExportOptions options;

    public ExportDatabaseOperation() {
    }

    public ExportDatabaseOperation(ExportOptions options) {
        this.options = options;
    }

    @Override
    protected void execute(Exchange exchange, NitriteEndpoint endpoint) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Exporter exporter = Exporter.of((Nitrite)endpoint.getNitriteDatabase());
        if (this.options != null) {
            exporter.withOptions(this.options);
        }
        exporter.exportTo((OutputStream)stream);
        exchange.getMessage().setBody((Object)stream.toByteArray());
    }
}

