/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.neo4j.transformer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="neo4j:rag", description="Prepares the similarity search LangChain4j embeddings to become a List of String for LangChain4j RAG")
public class Neo4jReverseEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        List embeddings = (List)message.getBody(List.class);
        List result = embeddings.stream().map(embedding -> embedding.getOrDefault("text", "")).collect(Collectors.toList());
        message.setBody(result);
    }
}

