/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.neo4j;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.neo4j.Neo4Operation;
import org.apache.camel.component.neo4j.Neo4jEmbedding;
import org.apache.camel.component.neo4j.Neo4jEndpoint;
import org.apache.camel.component.neo4j.Neo4jOperationException;
import org.apache.camel.component.neo4j.Neo4jSimilarityFunction;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.neo4j.driver.Driver;
import org.neo4j.driver.EagerResult;
import org.neo4j.driver.QueryConfig;
import org.neo4j.driver.Record;
import org.neo4j.driver.Values;
import org.neo4j.driver.summary.ResultSummary;

public class Neo4jProducer
extends DefaultProducer {
    private Driver driver;

    public Neo4jProducer(Neo4jEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public Neo4jEndpoint getEndpoint() {
        return (Neo4jEndpoint)super.getEndpoint();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.driver = this.getEndpoint().getDriver();
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        Neo4Operation operation = (Neo4Operation)((Object)in.getHeader("CamelNeo4jOperation", Neo4Operation.class));
        if (operation == null) {
            throw new NoSuchHeaderException("The operation is a required header", exchange, "CamelNeo4jOperation");
        }
        switch (operation) {
            case CREATE_NODE: {
                this.createNode(exchange);
                break;
            }
            case DELETE_NODE: {
                this.deleteNode(exchange);
                break;
            }
            case RETRIEVE_NODES: {
                this.retrieveNodes(exchange);
                break;
            }
            case RETRIEVE_NODES_AND_UPDATE_WITH_CYPHER_QUERY: {
                this.retrieveNodesWithCypherQuery(exchange);
                break;
            }
            case ADD_OR_DELETE_NODE_WITH_CYPHER_QUERY: {
                this.writeWithCypherQuery(exchange);
                break;
            }
            case CREATE_VECTOR_INDEX: {
                this.createVectorIndex(exchange);
                break;
            }
            case DROP_VECTOR_INDEX: {
                this.dropVectorIndex(exchange);
                break;
            }
            case CREATE_VECTOR: {
                this.createVector(exchange);
                break;
            }
            case VECTOR_SIMILARITY_SEARCH: {
                this.similaritySearch(exchange);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation: " + operation.name());
            }
        }
    }

    private void createNode(Exchange exchange) throws InvalidPayloadException {
        String label = this.getEndpoint().getConfiguration().getLabel();
        ObjectHelper.notNull((Object)label, (String)"label");
        String alias = this.getEndpoint().getConfiguration().getAlias();
        ObjectHelper.notNull((Object)alias, (String)"alias");
        Object body = exchange.getMessage().getBody();
        String databaseName = this.getEndpoint().getName();
        String query = "";
        Map<String, Object> properties = null;
        if (body instanceof String) {
            query = String.format("CREATE (%s:%s %s)", alias, label, body);
        } else {
            query = String.format("CREATE (%s:%s $props)", alias, label);
            properties = Map.of("props", body);
        }
        this.executeWriteQuery(exchange, query, properties, databaseName, Neo4Operation.CREATE_NODE);
    }

    private void retrieveNodes(Exchange exchange) throws NoSuchHeaderException {
        String label = this.getEndpoint().getConfiguration().getLabel();
        ObjectHelper.notNull((Object)label, (String)"label");
        String alias = this.getEndpoint().getConfiguration().getAlias();
        ObjectHelper.notNull((Object)alias, (String)"alias");
        String matchQuery = (String)exchange.getMessage().getHeader("CamelNeo4jMatchProperties", String.class);
        if (matchQuery == null) {
            matchQuery = "";
        }
        String databaseName = this.getEndpoint().getName();
        String query = String.format("MATCH (%s:%s %s) RETURN %s", alias, label, matchQuery, alias);
        this.queryRetriveNodes(exchange, databaseName, null, query, Neo4Operation.RETRIEVE_NODES);
    }

    private void retrieveNodesWithCypherQuery(Exchange exchange) throws NoSuchHeaderException {
        String query = (String)exchange.getMessage().getBody(String.class);
        String databaseName = this.getEndpoint().getName();
        this.queryRetriveNodes(exchange, databaseName, null, query, Neo4Operation.RETRIEVE_NODES_AND_UPDATE_WITH_CYPHER_QUERY);
    }

    private void queryRetriveNodes(Exchange exchange, String databaseName, Map<String, Object> queryParams, String query, Neo4Operation operation) {
        try {
            EagerResult result = queryParams != null ? this.driver.executableQuery(query).withConfig(QueryConfig.builder().withDatabase(databaseName).build()).withParameters(queryParams).execute() : this.driver.executableQuery(query).withConfig(QueryConfig.builder().withDatabase(databaseName).build()).execute();
            List records = result.records();
            exchange.getMessage().setHeader("CamelNeo4jQueryResultRetrieveSize", (Object)records.size());
            exchange.getMessage().setHeader("CamelNeo4jQueryResultListNeo4jNodes", (Object)records);
            exchange.getMessage().setBody((Object)this.nodeProperties(records));
        }
        catch (Exception error) {
            exchange.setException((Throwable)new Neo4jOperationException(operation, (Throwable)error));
        }
    }

    private List nodeProperties(List<Record> result) {
        return result.stream().map(record -> record.get(0).asNode()).map(node -> node.asMap()).collect(Collectors.toList());
    }

    private void deleteNode(Exchange exchange) throws NoSuchHeaderException {
        String label = this.getEndpoint().getConfiguration().getLabel();
        ObjectHelper.notNull((Object)label, (String)"label");
        String alias = this.getEndpoint().getConfiguration().getAlias();
        ObjectHelper.notNull((Object)alias, (String)"alias");
        String matchQuery = (String)exchange.getMessage().getHeader("CamelNeo4jMatchProperties", String.class);
        if (matchQuery == null) {
            matchQuery = "";
        }
        String databaseName = this.getEndpoint().getName();
        String detached = this.getEndpoint().getConfiguration().isDetachRelationship() ? "DETACH" : "";
        String query = String.format("MATCH (%s:%s %s) %s DELETE %s", alias, label, matchQuery, detached, alias);
        this.executeWriteQuery(exchange, query, null, databaseName, Neo4Operation.DELETE_NODE);
    }

    private void createVectorIndex(Exchange exchange) {
        String vectorIndexName = this.getEndpoint().getConfiguration().getVectorIndexName();
        ObjectHelper.notNull((Object)vectorIndexName, (String)"vectorIndexName");
        String label = this.getEndpoint().getConfiguration().getLabel();
        ObjectHelper.notNull((Object)label, (String)"label");
        String alias = this.getEndpoint().getConfiguration().getAlias();
        ObjectHelper.notNull((Object)alias, (String)"alias");
        int dimension = this.getEndpoint().getConfiguration().getDimension();
        ObjectHelper.notNull((Object)dimension, (String)"dimension");
        Neo4jSimilarityFunction similarityFunction = this.getEndpoint().getConfiguration().getSimilarityFunction();
        ObjectHelper.notNull((Object)((Object)similarityFunction), (String)"similarityFunction");
        String databaseName = this.getEndpoint().getName();
        String query = String.format("CREATE VECTOR INDEX %s IF NOT EXISTS\nFOR (%s:%s)\nON %s.embedding\nOPTIONS { indexConfig: {\n `vector.dimensions`: %s,\n `vector.similarity_function`: '%s'\n}}", vectorIndexName, alias, label, alias, dimension, similarityFunction.name());
        this.executeWriteQuery(exchange, query, null, databaseName, Neo4Operation.CREATE_VECTOR_INDEX);
    }

    private void dropVectorIndex(Exchange exchange) {
        String vectorIndexName = this.getEndpoint().getConfiguration().getVectorIndexName();
        ObjectHelper.notNull((Object)vectorIndexName, (String)"vectorIndexName");
        String databaseName = this.getEndpoint().getName();
        String query = String.format("DROP INDEX %s", vectorIndexName);
        this.executeWriteQuery(exchange, query, null, databaseName, Neo4Operation.DROP_VECTOR_INDEX);
    }

    private void createVector(Exchange exchange) {
        float[] vectors;
        String text;
        String id;
        String alias = this.getEndpoint().getConfiguration().getAlias() != null ? this.getEndpoint().getConfiguration().getAlias() : "e";
        String label = this.getEndpoint().getConfiguration().getLabel() != null ? this.getEndpoint().getConfiguration().getLabel() : "Embedding";
        String databaseName = this.getEndpoint().getName();
        Object body = exchange.getMessage().getBody();
        if (body instanceof Neo4jEmbedding) {
            id = ((Neo4jEmbedding)body).getId();
            text = ((Neo4jEmbedding)body).getText();
            vectors = ((Neo4jEmbedding)body).getVectors();
        } else {
            id = (String)exchange.getMessage().getHeader("CamelNeo4jVectorEmbeddingId", () -> UUID.randomUUID(), String.class);
            vectors = (float[])exchange.getMessage().getHeader("CamelLangChain4jEmbeddingsVector", float[].class);
            text = (String)exchange.getMessage().getBody(String.class);
        }
        ObjectHelper.notNull((Object)text, (String)"text");
        ObjectHelper.notNull((Object)vectors, (String)"vectors");
        String query = String.format("MERGE (%s:%s {id: $id, text: $text})\nWITH %s\nCALL db.create.setNodeVectorProperty(%s, 'embedding', $embedding);\n", alias, label, alias, alias);
        Map<String, Object> params = Map.of("embedding", Values.value((float[])vectors), "id", id, "text", text);
        this.executeWriteQuery(exchange, query, params, databaseName, Neo4Operation.CREATE_VECTOR);
    }

    public void similaritySearch(Exchange exchange) throws InvalidPayloadException {
        String vectorIndexName = this.getEndpoint().getConfiguration().getVectorIndexName();
        ObjectHelper.notNull((Object)vectorIndexName, (String)"vectorIndexName");
        Object body = exchange.getMessage().getMandatoryBody();
        float[] vectors = body instanceof Neo4jEmbedding ? ((Neo4jEmbedding)body).getVectors() : (float[])exchange.getMessage().getBody(float[].class);
        double minScore = this.getEndpoint().getConfiguration().getMinScore();
        double maxResults = this.getEndpoint().getConfiguration().getMaxResults();
        String databaseName = this.getEndpoint().getName();
        String query = "CALL db.index.vector.queryNodes($indexName, $maxResults, $embeddingValue)\nYIELD node, score\nWHERE score >= $minScore\nRETURN *\n";
        Map<String, Object> params = Map.of("indexName", vectorIndexName, "embeddingValue", vectors, "minScore", minScore, "maxResults", maxResults);
        this.queryRetriveNodes(exchange, databaseName, params, query, Neo4Operation.VECTOR_SIMILARITY_SEARCH);
    }

    private void writeWithCypherQuery(Exchange exchange) {
        String query = (String)exchange.getMessage().getBody(String.class);
        String databaseName = this.getEndpoint().getName();
        this.executeWriteQuery(exchange, query, null, databaseName, Neo4Operation.ADD_OR_DELETE_NODE_WITH_CYPHER_QUERY);
    }

    private void executeWriteQuery(Exchange exchange, String query, Map<String, Object> properties, String databaseName, Neo4Operation operation) {
        try {
            EagerResult result = properties != null ? this.driver.executableQuery(query).withConfig(QueryConfig.builder().withDatabase(databaseName).build()).withParameters(properties).execute() : this.driver.executableQuery(query).withConfig(QueryConfig.builder().withDatabase(databaseName).build()).execute();
            ResultSummary summary = result.summary();
            exchange.getMessage().setHeader("CamelNeo4jQueryResult", (Object)summary.query().text());
            exchange.getMessage().setHeader("CamelNeo4jQueryResultNodesCreated", (Object)summary.counters().nodesCreated());
            exchange.getMessage().setHeader("CamelNeo4jQueryResultNodesDeleted", (Object)summary.counters().nodesDeleted());
            exchange.getMessage().setHeader("CamelNeo4jQueryResultContainsUpdates", (Object)summary.counters().containsUpdates());
            exchange.getMessage().setHeader("CamelNeo4jQueryResultRelationshipsCreated", (Object)summary.counters().relationshipsCreated());
            exchange.getMessage().setHeader("CamelNeo4jQueryResultRelationshipsDeleted", (Object)summary.counters().relationshipsDeleted());
        }
        catch (Exception error) {
            exchange.setException((Throwable)new Neo4jOperationException(operation, (Throwable)error));
        }
    }
}

