/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.mvel;

import java.io.Serializable;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.language.mvel.RootObject;
import org.apache.camel.support.ExpressionSupport;
import org.mvel2.MVEL;

public class MvelExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private final Serializable compiled;

    public MvelExpression(String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
        try {
            this.compiled = MVEL.compileExpression((String)expressionString);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(expressionString, (Throwable)e);
        }
    }

    public static MvelExpression mvel(String expression) {
        return new MvelExpression(expression, Object.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        try {
            Object value = MVEL.executeExpression((Object)this.compiled, (Object)new RootObject(exchange));
            return (T)exchange.getContext().getTypeConverter().convertTo(tClass, value);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    public Object evaluate(Exchange exchange) {
        try {
            return MVEL.executeExpression((Object)this.compiled, (Object)new RootObject(exchange));
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public String toString() {
        return "Mvel[" + this.expressionString + "]";
    }
}

