/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mustache.MustacheEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="mustache")
public class MustacheComponent
extends DefaultComponent {
    @Metadata(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache = true;
    @Metadata
    private boolean allowTemplateFromHeader;
    @Metadata
    private boolean allowContextMapAll;
    @Metadata(label="advanced", autowired=true)
    private MustacheFactory mustacheFactory;

    protected void doInit() throws Exception {
        super.doInit();
        if (this.mustacheFactory == null) {
            this.mustacheFactory = new DefaultMustacheFactory();
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MustacheEndpoint endpoint = new MustacheEndpoint(uri, (Component)this, remaining);
        endpoint.setMustacheFactory(this.getMustacheFactory());
        endpoint.setContentCache(this.contentCache);
        endpoint.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        endpoint.setAllowContextMapAll(this.allowContextMapAll);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public MustacheFactory getMustacheFactory() {
        return this.mustacheFactory;
    }

    public void setMustacheFactory(MustacheFactory mustacheFactory) {
        this.mustacheFactory = mustacheFactory;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }
}

