/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.component.mock.MockExpressionClause;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.builder.PredicateBuilder;

public class MockValueBuilder
implements Expression,
Predicate {
    private Expression expression;
    private boolean not;

    public MockValueBuilder(Expression expression) {
        this.expression = expression;
    }

    public void init(CamelContext context) {
        this.expression.init(context);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return (T)this.expression.evaluate(exchange, type);
    }

    public boolean matches(Exchange exchange) {
        return PredicateBuilder.toPredicate((Expression)this.getExpression()).matches(exchange);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public Predicate matches(Expression expression) {
        return this.onNewPredicate(ExpressionToPredicateAdapter.toPredicate((Expression)expression));
    }

    public MockExpressionClause<Predicate> matches() {
        final AtomicReference<2> ref = new AtomicReference<2>();
        final MockExpressionClause<Predicate> answer = new MockExpressionClause<Predicate>(this.onNewPredicate(new Predicate(){

            public boolean matches(Exchange exchange) {
                Expression left = MockValueBuilder.this.expression;
                Expression right = (Expression)ref.get();
                return PredicateBuilder.isEqualTo((Expression)left, (Expression)right).matches(exchange);
            }

            public String toString() {
                return MockValueBuilder.this.expression + " == " + ref.get();
            }
        }));
        ExpressionAdapter right = new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return answer.evaluate(exchange, Object.class);
            }
        };
        ref.set(right);
        return answer;
    }

    public Predicate isNotEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isNotEqualTo((Expression)this.expression, (Expression)right));
    }

    public Predicate isEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isEqualTo((Expression)this.expression, (Expression)right));
    }

    public Predicate isEqualToIgnoreCase(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isEqualToIgnoreCase((Expression)this.expression, (Expression)right));
    }

    public Predicate isLessThan(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThan((Expression)this.expression, (Expression)right));
    }

    public Predicate isLessThanOrEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThanOrEqualTo((Expression)this.expression, (Expression)right));
    }

    public Predicate isGreaterThan(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThan((Expression)this.expression, (Expression)right));
    }

    public Predicate isGreaterThanOrEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThanOrEqualTo((Expression)this.expression, (Expression)right));
    }

    public Predicate isInstanceOf(Class<?> type) {
        return this.onNewPredicate(PredicateBuilder.isInstanceOf((Expression)this.expression, type));
    }

    public Predicate isNull() {
        return this.onNewPredicate(PredicateBuilder.isNull((Expression)this.expression));
    }

    public Predicate isNotNull() {
        return this.onNewPredicate(PredicateBuilder.isNotNull((Expression)this.expression));
    }

    public Predicate not(Predicate predicate) {
        return this.onNewPredicate(PredicateBuilder.not((Predicate)predicate));
    }

    public Predicate in(Object ... values) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Object value : values) {
            Expression right = this.asExpression(value);
            right = ExpressionBuilder.convertToExpression((Expression)right, (Expression)this.expression);
            Predicate predicate = PredicateBuilder.isEqualTo((Expression)this.expression, (Expression)right);
            predicates.add(predicate);
        }
        return this.in(predicates.toArray(new Predicate[predicates.size()]));
    }

    public Predicate in(Predicate ... predicates) {
        return this.onNewPredicate(PredicateBuilder.in((Predicate[])predicates));
    }

    public Predicate startsWith(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.startsWith((Expression)this.expression, (Expression)right));
    }

    public Predicate endsWith(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.endsWith((Expression)this.expression, (Expression)right));
    }

    public Predicate contains(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.contains((Expression)this.expression, (Expression)right));
    }

    public Predicate regex(String regex) {
        return this.onNewPredicate(PredicateBuilder.regex((Expression)this.expression, (String)regex));
    }

    public MockValueBuilder tokenize() {
        return this.tokenize("\n");
    }

    public MockValueBuilder tokenize(String token) {
        Expression newExp = ExpressionBuilder.tokenizeExpression((Expression)this.expression, (String)token);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder tokenize(String token, int group, boolean skipFirst) {
        return this.tokenize(token, "" + group, skipFirst);
    }

    public MockValueBuilder tokenize(String token, String group, boolean skipFirst) {
        Expression newExp = ExpressionBuilder.tokenizeExpression((Expression)this.expression, (String)token);
        if (group == null && skipFirst) {
            newExp = ExpressionBuilder.skipFirstExpression((Expression)newExp);
        }
        newExp = ExpressionBuilder.groupIteratorExpression((Expression)newExp, (String)token, (String)group, (boolean)skipFirst);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder regexTokenize(String regex) {
        Expression newExp = ExpressionBuilder.regexTokenizeExpression((Expression)this.expression, (String)regex);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder regexReplaceAll(String regex, String replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll((Expression)this.expression, (String)regex, (String)replacement);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder regexReplaceAll(String regex, Expression replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll((Expression)this.expression, (String)regex, (Expression)replacement);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder convertTo(Class<?> type) {
        Expression newExp = ExpressionBuilder.convertToExpression((Expression)this.expression, type);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder convertToString() {
        return this.convertTo(String.class);
    }

    public MockValueBuilder append(Object value) {
        Expression newExp = ExpressionBuilder.append((Expression)this.expression, (Expression)this.asExpression(value));
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder prepend(Object value) {
        Expression newExp = ExpressionBuilder.prepend((Expression)this.expression, (Expression)this.asExpression(value));
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder sort(Comparator<?> comparator) {
        Expression newExp = ExpressionBuilder.sortExpression((Expression)this.expression, comparator);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder not() {
        this.not = true;
        return this;
    }

    protected Predicate onNewPredicate(Predicate predicate) {
        if (this.not) {
            return PredicateBuilder.not((Predicate)predicate);
        }
        return predicate;
    }

    protected Expression asExpression(Object value) {
        if (value instanceof Expression) {
            return (Expression)value;
        }
        return ExpressionBuilder.constantExpression((Object)value);
    }

    protected MockValueBuilder onNewValueBuilder(Expression exp) {
        return new MockValueBuilder(exp);
    }
}

