/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.internal;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.camel.Route;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.component.mllp.internal.MllpSocketBuffer;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TcpServerAcceptThread
extends Thread {
    Logger log = LoggerFactory.getLogger(this.getClass());
    MllpTcpServerConsumer consumer;
    ServerSocket serverSocket;
    boolean running;

    public TcpServerAcceptThread(MllpTcpServerConsumer consumer, ServerSocket serverSocket) {
        this.consumer = consumer;
        this.serverSocket = serverSocket;
    }

    String createThreadName(ServerSocket serverSocket) {
        String fullClassName = this.getClass().getName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        String fullEndpointKey = this.consumer.getEndpoint().getEndpointKey();
        String endpointKey = StringHelper.before((String)fullEndpointKey, (String)"?", (String)fullEndpointKey);
        return String.format("%s[%s] - %s", className, endpointKey, serverSocket.getLocalSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String routeId;
        this.running = true;
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.createThreadName(this.serverSocket));
        MDC.put((String)"camel.contextId", (String)this.consumer.getEndpoint().getCamelContext().getName());
        Route route = this.consumer.getRoute();
        if (route != null && (routeId = route.getId()) != null) {
            MDC.put((String)"camel.routeId", (String)route.getId());
        }
        this.log.info("Starting ServerSocket accept thread for {}", (Object)this.serverSocket);
        try {
            while (this.running && null != this.serverSocket && this.serverSocket.isBound() && !this.serverSocket.isClosed()) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                }
                catch (SocketTimeoutException timeoutEx) {
                    this.log.debug("Timeout waiting for client connection - keep listening");
                    continue;
                }
                catch (SocketException socketEx) {
                    if (!this.serverSocket.isBound()) continue;
                    try {
                        this.serverSocket.close();
                        continue;
                    }
                    catch (Exception ex) {
                        this.log.debug("Exception encountered closing ServerSocket after SocketException on accept() - ignoring", (Throwable)ex);
                        continue;
                    }
                }
                catch (IOException ioEx) {
                    this.log.error("Exception encountered accepting connection - closing ServerSocket", (Throwable)ioEx);
                    if (!this.serverSocket.isBound()) continue;
                    try {
                        this.serverSocket.close();
                        continue;
                    }
                    catch (Exception ex) {
                        this.log.debug("Exception encountered closing ServerSocket after exception on accept() - ignoring", (Throwable)ex);
                        continue;
                    }
                }
                if (!MllpSocketBuffer.isConnectionValid(socket)) continue;
                this.consumer.validateConsumer(socket);
            }
            return;
        }
        finally {
            this.log.info("ServerSocket.accept loop finished - closing listener");
            if (null != this.serverSocket && this.serverSocket.isBound() && !this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception ex) {
                    this.log.debug("Exception encountered closing ServerSocket after accept loop had exited - ignoring", (Throwable)ex);
                }
            }
            Thread.currentThread().setName(originalThreadName);
            MDC.remove((String)"camel.routeId");
            MDC.remove((String)"camel.contextId");
        }
    }

    @Override
    public void interrupt() {
        this.running = false;
        super.interrupt();
        if (null != this.serverSocket && this.serverSocket.isBound()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ioEx) {
                this.log.warn("Exception encountered closing ServerSocket in interrupt() method - ignoring", (Throwable)ioEx);
            }
        }
    }
}

