/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.minio.MinioChecks;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioConstants;
import org.apache.camel.component.minio.MinioConsumer;
import org.apache.camel.component.minio.MinioProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.5.0", scheme="minio", title="Minio", syntax="minio:bucketName", category={Category.CLOUD, Category.FILE}, headersClass=MinioConstants.class)
public class MinioEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(MinioEndpoint.class);
    private MinioClient minioClient;
    @UriParam
    private MinioConfiguration configuration;

    public MinioEndpoint(String uri, Component component, MinioConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.configuration.getEndpoint();
    }

    public String getServiceProtocol() {
        return "rest";
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        MinioConsumer minioConsumer = new MinioConsumer(this, processor);
        this.configureConsumer((Consumer)minioConsumer);
        minioConsumer.setMaxMessagesPerPoll(this.configuration.getMaxMessagesPerPoll());
        return minioConsumer;
    }

    public Producer createProducer() {
        return new MinioProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.minioClient = ObjectHelper.isNotEmpty((Object)this.getConfiguration().getMinioClient()) ? this.getConfiguration().getMinioClient() : this.createMinioClient();
        String objectName = this.getConfiguration().getObjectName();
        if (ObjectHelper.isNotEmpty((String)objectName)) {
            LOG.trace("Object name {} requested, so skipping bucket check...", (Object)objectName);
            return;
        }
        String bucketName = this.getConfiguration().getBucketName();
        LOG.trace("Querying whether bucket {} already exists...", (Object)bucketName);
        if (this.bucketExists(bucketName)) {
            LOG.trace("Bucket {} already exists", (Object)bucketName);
        } else if (this.getConfiguration().isAutoCreateBucket()) {
            LOG.trace("AutoCreateBucket set to true, Creating bucket {}...", (Object)bucketName);
            this.makeBucket(bucketName);
            LOG.trace("Bucket created");
        }
        if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getPolicy())) {
            LOG.trace("Updating bucket {} with policy {}", (Object)bucketName, (Object)this.configuration.getPolicy());
            this.setBucketPolicy(bucketName);
            LOG.trace("Bucket policy updated");
        }
    }

    public void doStop() throws Exception {
        super.doStop();
    }

    public MinioConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinioConfiguration configuration) {
        this.configuration = configuration;
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    MinioClient createMinioClient() {
        if (ObjectHelper.isNotEmpty((String)this.configuration.getEndpoint())) {
            MinioClient.Builder minioClientRequest = MinioClient.builder();
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
                minioClientRequest.endpoint(this.configuration.getEndpoint(), this.configuration.getProxyPort().intValue(), this.configuration.isSecure());
            } else {
                minioClientRequest.endpoint(this.configuration.getEndpoint());
            }
            if (ObjectHelper.isNotEmpty((String)this.configuration.getAccessKey()) && ObjectHelper.isNotEmpty((String)this.configuration.getSecretKey())) {
                minioClientRequest.credentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            }
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                minioClientRequest.region(this.configuration.getRegion());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getCustomHttpClient())) {
                minioClientRequest.httpClient(this.configuration.getCustomHttpClient());
            }
            return minioClientRequest.build();
        }
        throw new IllegalArgumentException("Endpoint must be specified");
    }

    private boolean bucketExists(String bucketName) throws Exception {
        return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    private void makeBucket(String bucketName) throws Exception {
        MakeBucketArgs.Builder makeBucketRequest = ((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).objectLock(this.getConfiguration().isObjectLock());
        if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getRegion())) {
            makeBucketRequest.region(this.getConfiguration().getRegion());
        }
        this.minioClient.makeBucket((MakeBucketArgs)makeBucketRequest.build());
    }

    private void setBucketPolicy(String bucketName) throws Exception {
        LOG.trace("Updating bucket {} with policy...", (Object)bucketName);
        this.minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(this.getConfiguration().getPolicy()).build());
        LOG.trace("Bucket policy updated");
    }

    void getObjectStat(String objectName, Message message) throws Exception {
        String bucketName = this.getConfiguration().getBucketName();
        StatObjectArgs.Builder statObjectRequest = (StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getServerSideEncryptionCustomerKey, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).ssec(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getOffset, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).offset(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getLength, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).length(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getVersionId, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).versionId(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getMatchETag, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).matchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getNotMatchETag, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).notMatchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getModifiedSince, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).modifiedSince(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getUnModifiedSince, arg_0 -> ((StatObjectArgs.Builder)statObjectRequest).unmodifiedSince(arg_0));
        StatObjectResponse stat = this.minioClient.statObject((StatObjectArgs)statObjectRequest.build());
        message.setHeader("CamelMinioObjectName", (Object)stat.object());
        message.setHeader("CamelMinioBucketName", (Object)stat.bucket());
        message.setHeader("CamelMinioETag", (Object)stat.etag());
        message.setHeader("CamelMinioLastModified", (Object)stat.headers().get("last-modified"));
        message.setHeader("CamelMinioVersionId", (Object)stat.headers().get("x-amz-version-id"));
        message.setHeader("CamelMinioContentType", (Object)stat.contentType());
        message.setHeader("CamelMinioContentLength", (Object)stat.size());
        message.setHeader("CamelMinioContentEncoding", (Object)stat.headers().get("content-encoding"));
        message.setHeader("CamelMinioContentDisposition", (Object)stat.headers().get("content-disposition"));
        message.setHeader("CamelMinioContentControl", (Object)stat.headers().get("cache-control"));
        message.setHeader("CamelMinioServerSideEncryption", (Object)stat.headers().get("x-amz-server-side-encryption"));
        message.setHeader("CamelMinioExpirationTime", (Object)stat.headers().get("x-amz-expiration"));
        message.setHeader("CamelMinioReplicationStatus", (Object)stat.headers().get("x-amz-replication-status"));
        message.setHeader("CamelMinioStorageClass", (Object)stat.headers().get("x-amz-storage-class"));
    }
}

